/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.geoip;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.File;
import java.net.InetAddress;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scouter.server.ConfObserver$;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.util.CompareUtil;

public final class GISDataUtil$ {
    public static final GISDataUtil$ MODULE$;
    private final Configure conf;
    private LookupService lookupService;
    private String path;
    private final Location dummy;

    static {
        new GISDataUtil$();
    }

    public Configure conf() {
        return this.conf;
    }

    public LookupService lookupService() {
        return this.lookupService;
    }

    public void lookupService_$eq(LookupService x$1) {
        this.lookupService = x$1;
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    public void load() {
        try {
            File fGeoIpDB = new File(this.conf().geoip_data_city_file);
            if (!fGeoIpDB.exists()) {
                Logger$.MODULE$.println("S145", new StringBuilder().append((Object)"GeoIP db file is not readable : ").append((Object)fGeoIpDB.getCanonicalPath()).toString());
            } else {
                this.lookupService_$eq(new LookupService(fGeoIpDB, 1));
                Logger$.MODULE$.println("S146", new StringBuilder().append((Object)"GeoIP db file is loaded : ").append((Object)fGeoIpDB.getCanonicalPath()).toString());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isOk() {
        return this.lookupService() != null;
    }

    public Location dummy() {
        return this.dummy;
    }

    public Location getGeoIPInfos(InetAddress ip) {
        if (this.lookupService() == null) {
            return this.dummy();
        }
        return this.lookupService().getLocation(ip);
    }

    private GISDataUtil$() {
        MODULE$ = this;
        this.conf = Configure.getInstance();
        this.lookupService = null;
        this.path = this.conf().geoip_data_city_file;
        ConfObserver$.MODULE$.put("GISDataUtil", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply() {
                BoxedUnit boxedUnit;
                if (!CompareUtil.equals(GISDataUtil$.MODULE$.path(), GISDataUtil$.MODULE$.conf().geoip_data_city_file)) {
                    GISDataUtil$.MODULE$.path_$eq(GISDataUtil$.MODULE$.conf().geoip_data_city_file);
                    GISDataUtil$.MODULE$.load();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
        });
        this.load();
        this.dummy = new Location();
    }
}

