/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.logs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Set;
import scouter.server.Configure;
import scouter.server.LoginManager;
import scouter.server.LoginUser;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public class RequestLogger
extends Thread {
    private static final String FILE_PREFIX = "request";
    private static final String DIRECTORY = Configure.getInstance().log_dir;
    private static RequestLogger instance;
    public static Set<String> cmdSet;
    public static Set<String> demandSet;
    private RequestQueue<RequestInfo> queue = new RequestQueue(1000);
    boolean running = true;
    private long dateUnit;
    private File outFile;

    public static synchronized RequestLogger getInstance() {
        if (instance == null) {
            instance = new RequestLogger();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public boolean add(String cmd, long session) {
        if (cmdSet.contains(cmd)) {
            LoginUser loginUser = LoginManager.getUser(session);
            if (loginUser != null) {
                this.queue.put(new RequestInfo(System.currentTimeMillis(), loginUser.id(), loginUser.ip(), cmd));
                return true;
            }
            this.queue.put(new RequestInfo(System.currentTimeMillis(), "unknown" + session, "", cmd));
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            RequestInfo r = this.queue.get();
            BufferedWriter bw = null;
            try {
                File file = this.getFile();
                bw = new BufferedWriter(new FileWriter(file, true));
                bw.write(r.toString());
                bw.newLine();
            }
            catch (Throwable e) {
                try {
                    this.outFile = null;
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtil.close(bw);
                    continue;
                }
            }
            FileUtil.close(bw);
        }
    }

    private File getFile() {
        if (this.outFile == null || this.dateUnit != DateUtil.getDateUnit()) {
            String filename = "request-" + DateUtil.yyyymmdd() + ".log";
            this.outFile = new File(DIRECTORY, filename);
            File parentDir = new File(DIRECTORY);
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
        }
        return this.outFile;
    }

    public synchronized void registerCmd(String cmd) {
        if (cmdSet.contains(cmd) || demandSet.contains(cmd)) {
            return;
        }
        cmdSet.add(cmd);
        this.queue.put(new RequestInfo(System.currentTimeMillis(), "unknown", "register", cmd));
    }

    static {
        cmdSet = new HashSet<String>();
        demandSet = new HashSet<String>();
        cmdSet.add("SERVER_DB_DELETE");
        cmdSet.add("REMOTE_CONTROL");
        cmdSet.add("REMOTE_CONTROL_ALL");
        cmdSet.add("TRANX_LOAD_TIME_GROUP");
        demandSet.add("ACTIVE_QUERY_LIST");
    }

    class RequestInfo {
        long time;
        String user;
        String ip;
        String cmd;

        RequestInfo(long time, String user, String ip, String cmd) {
            this.time = time;
            this.user = user;
            this.ip = ip;
            this.cmd = cmd;
        }

        public String toString() {
            return DateUtil.timestamp(this.time) + " " + this.user + "(" + this.ip + ") " + this.cmd;
        }
    }
}

