/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.List;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.server.core.AgentManager$;
import scouter.server.db.BatchDB$;
import scouter.server.db.BatchZipDB;
import scouter.server.netio.AgentCall$;
import scouter.server.netio.service.anotation.ServiceHandler;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u001b\ta!)\u0019;dQN+'O^5dK*\u00111\u0001B\u0001\u0007Q\u0006tG\r\\3\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\tAA]3bIR!AdH\u0014-!\tyQ$\u0003\u0002\u001f!\t!QK\\5u\u0011\u0015\u0001\u0013\u00041\u0001\"\u0003\r!\u0017N\u001c\t\u0003E\u0015j\u0011a\t\u0006\u0003I)\t!![8\n\u0005\u0019\u001a#A\u0003#bi\u0006Le\u000e];u1\")\u0001&\u0007a\u0001S\u0005!Am\\;u!\t\u0011#&\u0003\u0002,G\tYA)\u0019;b\u001fV$\b/\u001e;Y\u0011\u0015i\u0013\u00041\u0001/\u0003\u0015awnZ5o!\tyq&\u0003\u00021!\t9!i\\8mK\u0006t\u0007\u0006B\r3qe\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0003\u0002\u0013\u0005tw\u000e^1uS>t\u0017BA\u001c5\u00059\u0019VM\u001d<jG\u0016D\u0015M\u001c3mKJ\fQA^1mk\u0016\f\u0013AO\u0001\u0013\u0005\u0006#6\tS0I\u0013N#vJU-`\u0019&\u001bF\u000bC\u0003=\u0001\u0011\u0005Q(\u0001\u0006sK\u0006$G)\u001a;bS2$B\u0001\b @\u0001\")\u0001e\u000fa\u0001C!)\u0001f\u000fa\u0001S!)Qf\u000fa\u0001]!\"1H\r\u001dCC\u0005\u0019\u0015\u0001\u0006\"B)\u000eCu\fS%T)>\u0013\u0016l\u0018#F)\u0006KE\nC\u0003F\u0001\u0011\u0005a)A\u0005sK\u0006$7\u000b^1dWR!Ad\u0012%J\u0011\u0015\u0001C\t1\u0001\"\u0011\u0015AC\t1\u0001*\u0011\u0015iC\t1\u0001/Q\u0011!%\u0007O&\"\u00031\u000b1CQ!U\u0007\"{\u0006*S*U\u001fJKvl\u0015+B\u0007.CQA\u0014\u0001\u0005\u0002=\u000ba#Y4f]R\f5\r^5wKN+'O^5dK2K7\u000f\u001e\u000b\u00059A\u000b&\u000bC\u0003!\u001b\u0002\u0007\u0011\u0005C\u0003)\u001b\u0002\u0007\u0011\u0006C\u0003.\u001b\u0002\u0007a\u0006\u000b\u0003Nea\"\u0016%A+\u00021=\u0013%*R\"U?\n\u000bEk\u0011%`\u0003\u000e#\u0016JV#`\u0019&\u001bF\u000bC\u0003X\u0001\u0011\u0005\u0001,A\bsK\u0006$\u0017i\u0019;jm\u0016\u001cF/Y2l)\u0011a\u0012LW.\t\u000b\u00012\u0006\u0019A\u0011\t\u000b!2\u0006\u0019A\u0015\t\u000b52\u0006\u0019\u0001\u0018)\tY\u0013\u0004(X\u0011\u0002=\u0006\u0011\")\u0011+D\u0011~\u000b5\tV%W\u000b~\u001bF+Q\"L\u0001")
public class BatchService {
    @ServiceHandler(value="BATCH_HISTORY_LIST")
    public void read(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        ObjectPack objInfo = AgentManager$.MODULE$.getAgent(objHash);
        if (objInfo == null) {
            return;
        }
        String objName = objInfo.objName;
        String filter = param.getText("filter");
        long response = param.getLong("response");
        long from = param.getLong("from");
        long to = param.getLong("to");
        Serializable handler = new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;

            public final void apply(long time, BatchPack data) {
                this.dout$1.writeByte(3);
                data.writeSimple(this.dout$1);
            }
            {
                this.dout$1 = dout$1;
            }
        };
        if (from > 0L && to > from) {
            BatchDB$.MODULE$.read(objName, from, to, filter, response, (Function2<Object, BatchPack, Object>)handler);
        }
    }

    @ServiceHandler(value="BATCH_HISTORY_DETAIL")
    public void readDetail(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        long time = param.getLong("time");
        long position = param.getLong("position");
        ObjectPack objInfo = AgentManager$.MODULE$.getAgent(objHash);
        if (objInfo == null) {
            return;
        }
        String objName = objInfo.objName;
        byte[] data = BatchDB$.MODULE$.read(objName, time, position);
        if (data != null) {
            DataInputX ins = new DataInputX(data);
            Pack pack = ins.readPack();
            dout.writeByte(3);
            dout.writePack(pack);
        }
    }

    @ServiceHandler(value="BATCH_HISTORY_STACK")
    public void readStack(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        long time = param.getLong("time");
        String filename = param.getText("filename");
        ObjectPack objInfo = AgentManager$.MODULE$.getAgent(objHash);
        if (objInfo == null) {
            return;
        }
        String objName = objInfo.objName;
        BatchZipDB.read(objName, time, filename, dout);
    }

    @ServiceHandler(value="OBJECT_BATCH_ACTIVE_LIST")
    public void agentActiveServiceList(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String objType2 = param.getText("objType");
        int objHash = param.getInt("objHash");
        if (objHash == 0) {
            if (objType2 == null) {
                return;
            }
            List<Object> agentList = AgentManager$.MODULE$.getLiveObjHashList(objType2);
            JavaConversions$.MODULE$.asScalaBuffer(agentList).foreach((Function1)new Serializable(this, dout, param){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$2;
                private final MapPack param$1;

                public final DataOutputX apply(int agent) {
                    DataOutputX dataOutputX;
                    ObjectPack o = AgentManager$.MODULE$.getAgent(agent);
                    MapPack p = AgentCall$.MODULE$.call(o, "OBJECT_BATCH_ACTIVE_LIST", this.param$1);
                    if (p == null) {
                        MapPack emptyPack = new MapPack();
                        emptyPack.put("objHash", agent);
                        this.dout$2.writeByte(3);
                        dataOutputX = this.dout$2.writePack(emptyPack);
                    } else {
                        p.put("objHash", agent);
                        this.dout$2.writeByte(3);
                        dataOutputX = this.dout$2.writePack(p);
                    }
                    return dataOutputX;
                }
                {
                    this.dout$2 = dout$2;
                    this.param$1 = param$1;
                }
            });
        } else {
            ObjectPack o = AgentManager$.MODULE$.getAgent(objHash);
            MapPack p = AgentCall$.MODULE$.call(o, "OBJECT_BATCH_ACTIVE_LIST", param);
            if (p == null) {
                MapPack emptyPack = new MapPack();
                emptyPack.put("objHash", objHash);
                dout.writeByte(3);
                dout.writePack(emptyPack);
            } else {
                p.put("objHash", objHash);
                dout.writeByte(3);
                dout.writePack(p);
            }
        }
    }

    @ServiceHandler(value="BATCH_ACTIVE_STACK")
    public void readActiveStack(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        ObjectPack o = AgentManager$.MODULE$.getAgent(objHash);
        MapPack p = AgentCall$.MODULE$.call(o, "BATCH_ACTIVE_STACK", param);
        if (p != null) {
            dout.writeByte(3);
            dout.writePack(p);
        }
    }
}

