/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.first;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import scala.Function0;
import scala.Function2;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.tagcnt.core.CountEnv$;
import scouter.server.tagcnt.core.DBKey;
import scouter.server.tagcnt.core.MoveToNextCollector$;
import scouter.server.tagcnt.core.TagCountUtil$;
import scouter.server.tagcnt.core.Top100FileCache$;
import scouter.server.tagcnt.first.FirstTCData;
import scouter.server.tagcnt.first.WorkDB;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.BackJob;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.LinkedMap;
import scouter.util.LongKeyMap;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public final class FirstTagCountDB$
implements IClose {
    public static final FirstTagCountDB$ MODULE$;
    private final Runnable r;
    private final int MAX_QUE_SIZE;
    private final RequestQueue<FirstTCData> scouter$server$tagcnt$first$FirstTagCountDB$$queue;
    private long lastflush;
    private final Object writeLock;
    private final LinkedMap<DBKey, WorkDB> scouter$server$tagcnt$first$FirstTagCountDB$$database;
    private ArrayList<DBKey> scouter$server$tagcnt$first$FirstTagCountDB$$idleConns;

    static {
        new FirstTagCountDB$();
    }

    public Runnable r() {
        return this.r;
    }

    public int MAX_QUE_SIZE() {
        return this.MAX_QUE_SIZE;
    }

    public RequestQueue<FirstTCData> scouter$server$tagcnt$first$FirstTagCountDB$$queue() {
        return this.scouter$server$tagcnt$first$FirstTagCountDB$$queue;
    }

    public void add(FirstTCData data) {
        while (this.scouter$server$tagcnt$first$FirstTagCountDB$$queue().size() >= this.MAX_QUE_SIZE()) {
            ThreadUtil.qWait();
            Logger$.MODULE$.println("S183", 10, "FirstTagCountDB queue is exceeded");
        }
        this.scouter$server$tagcnt$first$FirstTagCountDB$$queue().put(data);
    }

    public long lastflush() {
        return this.lastflush;
    }

    public void lastflush_$eq(long x$1) {
        this.lastflush = x$1;
    }

    private Object writeLock() {
        return this.writeLock;
    }

    public void updateNewCounting(String date, String objType2, long tagKey, Value tagValue, float[] count) {
        TagCountUtil$.MODULE$.check(count);
        WorkDB db = null;
        try {
            Object object = this.writeLock();
            synchronized (object) {
                db = this.scouter$server$tagcnt$first$FirstTagCountDB$$openWrite(DateUtil.getTime(date, "yyyyMMdd"), objType2);
                db.table().update(tagKey, tagValue, count);
                db.entry().push(tagKey, tagValue);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean scouter$server$tagcnt$first$FirstTagCountDB$$countingFirst100(WorkDB db, long tagKey, Value tagValue, int hhmm, float n) {
        return db.entry().add(tagKey, tagValue, hhmm, n);
    }

    public void scouter$server$tagcnt$first$FirstTagCountDB$$flush() {
        this.lastflush_$eq(System.currentTimeMillis());
        Object object = this.writeLock();
        synchronized (object) {
            Enumeration<WorkDB> en = this.scouter$server$tagcnt$first$FirstTagCountDB$$database().values();
            while (en.hasMoreElements()) {
                WorkDB ix = en.nextElement();
                ix.entry().save();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkDB scouter$server$tagcnt$first$FirstTagCountDB$$openWrite(long time, String objType2) {
        long dateunit = DateUtil.getDateUnit(time);
        WorkDB db = this.scouter$server$tagcnt$first$FirstTagCountDB$$database().get(new DBKey(dateunit, objType2));
        if (db != null) {
            db.lastActive_$eq(System.currentTimeMillis());
            return db;
        }
        db = this.open(DateUtil.yyyymmdd(time), objType2);
        if (db == null) {
            return null;
        }
        db.lastActive_$eq(System.currentTimeMillis());
        LinkedMap<DBKey, WorkDB> linkedMap = this.scouter$server$tagcnt$first$FirstTagCountDB$$database();
        synchronized (linkedMap) {
            while (true) {
                if (this.scouter$server$tagcnt$first$FirstTagCountDB$$database().size() < CountEnv$.MODULE$.MAX_ACTIVEDB()) {
                    this.scouter$server$tagcnt$first$FirstTagCountDB$$database().put(new DBKey(dateunit, objType2), db);
                    return db;
                }
                this.liftedTree1$1();
            }
        }
    }

    public LinkedMap<DBKey, WorkDB> scouter$server$tagcnt$first$FirstTagCountDB$$database() {
        return this.scouter$server$tagcnt$first$FirstTagCountDB$$database;
    }

    public ArrayList<DBKey> scouter$server$tagcnt$first$FirstTagCountDB$$idleConns() {
        return this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns;
    }

    private void scouter$server$tagcnt$first$FirstTagCountDB$$idleConns_$eq(ArrayList<DBKey> x$1) {
        this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns = x$1;
    }

    public void scouter$server$tagcnt$first$FirstTagCountDB$$closeIdleConnections() {
        if (this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns().isEmpty()) {
            return;
        }
        ArrayList<DBKey> idles = this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns();
        this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns_$eq(new ArrayList<DBKey>());
        for (int inx = 0; inx < idles.size(); ++inx) {
            WorkDB o = this.scouter$server$tagcnt$first$FirstTagCountDB$$database().remove(idles.get(inx));
            FileUtil.close(o);
        }
    }

    public WorkDB open(String date, String objType2) {
        WorkDB db = null;
        try {
            String path = CountEnv$.MODULE$.getDBPath(date, objType2);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            db = new WorkDB(path);
            db.open();
            db.objType_$eq(objType2);
            db.logDate_$eq(date);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return db;
    }

    public float[] getTagValueCount(String objType2, String date, long tagKey, Value tagValue) {
        float[] fArray;
        WorkDB db = this.open(date, objType2);
        try {
            fArray = db.table().get(tagKey, tagValue);
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
            }
            finally {
                FileUtil.close(db);
            }
            return null;
        }
        FileUtil.close(db);
        return fArray;
    }

    public LongKeyMap<Set<Value>> getTagValues(String objType2, String date) {
        WorkDB db = this.open(date, objType2);
        try {
            if (db == null) {
                return new LongKeyMap<Set<Value>>();
            }
            return db.entry().getTagValueSet();
        }
        finally {
            FileUtil.close(db);
        }
    }

    public Set<Value> getTagValues(String objType2, String date, long tagKey) {
        WorkDB db = this.open(date, objType2);
        try {
            if (db == null) {
                return new HashSet<Value>();
            }
            return db.entry().getTagValueSet().get(tagKey);
        }
        finally {
            FileUtil.close(db);
        }
    }

    public void read(String date, String objType2, Function2<byte[], int[], Object> handler) {
        WorkDB db = this.open(date, objType2);
        try {
            try {
                db.table().read(handler);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        finally {
            FileUtil.close(db);
        }
    }

    @Override
    public void close() {
        LinkedMap<DBKey, WorkDB> linkedMap = this.scouter$server$tagcnt$first$FirstTagCountDB$$database();
        synchronized (linkedMap) {
            while (this.scouter$server$tagcnt$first$FirstTagCountDB$$database().size() > 0) {
                this.scouter$server$tagcnt$first$FirstTagCountDB$$database().removeFirst().close();
            }
            return;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.scouter$server$tagcnt$first$FirstTagCountDB$$database().removeFirst().close();
        }
        catch (Throwable throwable) {}
    }

    private FirstTagCountDB$() {
        MODULE$ = this;
        this.r = new Runnable(){

            public void run() {
                long now = System.currentTimeMillis();
                EnumerScala$.MODULE$.foreach(FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$database().keys(), new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;

                    public final Object apply(DBKey key) {
                        WorkDB db = FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$database().get(key);
                        return db == null ? BoxedUnit.UNIT : (this.now$1 - db.lastActive() > 300000L ? BoxesRunTime.boxToBoolean((boolean)FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns().add(key)) : BoxedUnit.UNIT);
                    }
                    {
                        this.now$1 = now$1;
                    }
                });
            }
        };
        BackJob.getInstance().add("BG-FirstTagCountDB", 10000L, this.r());
        this.MAX_QUE_SIZE = 50000;
        this.scouter$server$tagcnt$first$FirstTagCountDB$$queue = new RequestQueue(this.MAX_QUE_SIZE() + 1);
        this.lastflush = System.currentTimeMillis();
        ThreadScala$.MODULE$.startDaemon("scouter.server.tagcnt.first.FirstTagCountDB", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    FirstTCData data;
                    WorkDB db;
                    if (!CountEnv$.MODULE$.running()) {
                        FileUtil.close(FirstTagCountDB$.MODULE$);
                        return;
                    }
                    FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$closeIdleConnections();
                    long now = System.currentTimeMillis();
                    if (now > FirstTagCountDB$.MODULE$.lastflush() + 5000L) {
                        FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$flush();
                    }
                    if ((db = FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$openWrite((data = FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$queue().get()).time(), data.objType())) == null) continue;
                    try {
                        int hhmm = TagCountUtil$.MODULE$.hhmm(data.time());
                        boolean ok = FirstTagCountDB$.MODULE$.scouter$server$tagcnt$first$FirstTagCountDB$$countingFirst100(db, data.tagKey(), data.tagValue(), hhmm, data.cnt());
                        if (!ok) {
                            MoveToNextCollector$.MODULE$.add(data.time(), data.objType(), data.tagKey(), data.tagValue(), data.cnt());
                        }
                        Top100FileCache$.MODULE$.add(db.logDate(), data.objType());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.writeLock = new Object();
        this.scouter$server$tagcnt$first$FirstTagCountDB$$database = new LinkedMap();
        this.scouter$server$tagcnt$first$FirstTagCountDB$$idleConns = new ArrayList();
    }
}

