/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.first;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataOutputX;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.db.io.MemHashBlock;
import scouter.server.tagcnt.core.TagCountUtil$;
import scouter.server.tagcnt.first.IndexFile$;
import scouter.server.tagcnt.first.KeyDataFile;
import scouter.util.CompareUtil;
import scouter.util.HashUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005ex!B\u0001\u0003\u0011\u0003Y\u0011!C%oI\u0016Dh)\u001b7f\u0015\t\u0019A!A\u0003gSJ\u001cHO\u0003\u0002\u0006\r\u00051A/Y4d]RT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005%Ie\u000eZ3y\r&dWm\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\t\u000fii!\u0019!C\u00017\u0005)A/\u00192mKV\tA\u0004\u0005\u0003\u001eE\u0011ZS\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001B;uS2T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\tI\u0001*Y:ii\u0006\u0014G.\u001a\t\u0003K!r!!\u0005\u0014\n\u0005\u001d\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\n\u0011\u00051ac\u0001\u0002\b\u0003\u00015\u001a2\u0001\f\u00185!\ty#'D\u00011\u0015\t\t\u0004%\u0001\u0003mC:<\u0017BA\u001a1\u0005\u0019y%M[3diB\u0011QgN\u0007\u0002m)\u0011q\u0004C\u0005\u0003qY\u0012a!S\"m_N,\u0007\u0002\u0003\u001e-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u000b}\u0003\u0018\r\u001e5\t\u0011qb#\u0011!Q\u0001\nu\n\u0001\u0002[1tQNK'0\u001a\t\u0003#yJ!a\u0010\n\u0003\u0007%sG\u000fC\u0003\u0018Y\u0011\u0005\u0011\tF\u0002,\u0005\u000eCQA\u000f!A\u0002\u0011Bq\u0001\u0010!\u0011\u0002\u0003\u0007Q\bC\u0004FY\u0001\u0007I\u0011\u0001$\u0002\u0011I,gM]3oG\u0016,\u0012!\u0010\u0005\b\u00112\u0002\r\u0011\"\u0001J\u00031\u0011XM\u001a:f]\u000e,w\fJ3r)\tQU\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019A\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004QY\u0001\u0006K!P\u0001\ne\u00164'/\u001a8dK\u0002BqA\u0015\u0017C\u0002\u0013\u0005a)\u0001\u0002N\u0005\"1A\u000b\fQ\u0001\nu\n1!\u0014\"!\u0011\u001d1FF1A\u0005\u0002]\u000bA\u0001]1uQV\tA\u0005\u0003\u0004ZY\u0001\u0006I\u0001J\u0001\u0006a\u0006$\b\u000e\t\u0005\b72\u0012\r\u0011\"\u0001]\u0003!A\u0017m\u001d5GS2,W#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017AA5p\u0015\t\u0011g!\u0001\u0002eE&\u0011Am\u0018\u0002\r\u001b\u0016l\u0007*Y:i\u00052|7m\u001b\u0005\u0007M2\u0002\u000b\u0011B/\u0002\u0013!\f7\u000f\u001b$jY\u0016\u0004\u0003b\u00025-\u0005\u0004%\t![\u0001\bW\u0016Lh)\u001b7f+\u0005Q\u0007C\u0001\u0007l\u0013\ta'AA\u0006LKf$\u0015\r^1GS2,\u0007B\u00028-A\u0003%!.\u0001\u0005lKf4\u0015\u000e\\3!\u0011\u0015\u0001H\u0006\"\u0001r\u0003\r\u0001X\u000f\u001e\u000b\u0004eVl\bCA\tt\u0013\t!(CA\u0004C_>dW-\u00198\t\u000bY|\u0007\u0019A<\u0002\u0007-,\u0017\u0010E\u0002\u0012qjL!!\u001f\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005EY\u0018B\u0001?\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u000by|\u0007\u0019A@\u0002\u000bY\fG.^3\u0011\tEA\u0018\u0011\u0001\t\u0004#\u0005\r\u0011bAA\u0003%\t)a\t\\8bi\"9\u0011\u0011\u0002\u0017\u0005\u0002\u0005-\u0011aA4fiR\u0019q0!\u0004\t\rY\f9\u00011\u0001x\u0011\u001d\t\t\u0002\fC\u0001\u0003'\t\u0011\"\u001e9eCR,\u0017\t\u001a3\u0015\u0011\u0005\u0005\u0011QCA\f\u00037AaA^A\b\u0001\u00049\bbBA\r\u0003\u001f\u0001\r!P\u0001\u0005Q\"lW\u000e\u0003\u0005\u0002\u001e\u0005=\u0001\u0019AA\u0001\u0003\r\u0019g\u000e\u001e\u0005\b\u0003CaC\u0011AA\u0012\u0003\u0019)\b\u000fZ1uKR)!*!\n\u0002(!1a/a\bA\u0002]DaA`A\u0010\u0001\u0004y\bbBA\u0016Y\u0011\u0005\u0011QF\u0001\u0007Q\u0006\u001c8*Z=\u0015\u0007I\fy\u0003\u0003\u0004w\u0003S\u0001\ra\u001e\u0005\b\u0003gaC\u0011AA\u001b\u0003\u00199W\r^!mYR!\u0011qGA\u001f!\u0011i\u0012\u0011H@\n\u0007\u0005mbD\u0001\u0003MSN$\bB\u0002<\u00022\u0001\u0007q\u000fC\u0004\u0002B1\"\t!a\u0011\u0002\r\u0011,G.\u001a;f)\ri\u0014Q\t\u0005\u0007m\u0006}\u0002\u0019A<\t\u000f\u0005%C\u0006\"\u0001\u0002L\u0005!!/Z1e)\r\u0011\u0018Q\n\u0005\t\u0003\u001f\n9\u00051\u0001\u0002R\u00059\u0001.\u00198eY\u0016\u0014\b\u0003C\t\u0002T]\f9&!\u0017\n\u0007\u0005U#CA\u0005Gk:\u001cG/[8oeA\u0019\u0011\u0003_\u001f\u0011\u0007E\tY&C\u0002\u0002^I\u00111!\u00118z\u0011\u001d\t\t\u0007\fC\u0001\u0003G\nqaZ3u'R\fG\u000f\u0006\u0002\u0002fA1Q$a\u001a%\u0003WJ1!!\u001b\u001f\u0005\ri\u0015\r\u001d\t\u0004_\u00055\u0014bAA8a\t1a*^7cKJDq!a\u001d-\t\u0013\t)(\u0001\u0004`G2|7/\u001a\u000b\u0002\u0015\"9\u0011\u0011\u0010\u0017\u0005\u0002\u0005U\u0014!B2m_N,\u0007bBA?Y\u0011\u0005\u0011qP\u0001\u0004g\u0016$Hc\u0002&\u0002\u0002\u0006-\u00151\u0014\u0005\t\u0003\u0007\u000bY\b1\u0001\u0002\u0006\u00061A/Y4LKf\u00042!EAD\u0013\r\tII\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u000e\u0006m\u0004\u0019AAH\u0003!!\u0018m\u001a,bYV,\u0007\u0003BAI\u0003/k!!a%\u000b\u0007y\f)J\u0003\u00022\u0011%!\u0011\u0011TAJ\u0005\u00151\u0016\r\\;f\u0011\u0019q\u00181\u0010a\u0001\u007f\"9\u0011\u0011\u0005\u0017\u0005\u0002\u0005}Ec\u0002&\u0002\"\u0006\r\u0016Q\u0015\u0005\t\u0003\u0007\u000bi\n1\u0001\u0002\u0006\"A\u0011QRAO\u0001\u0004\ty\t\u0003\u0004\u007f\u0003;\u0003\ra \u0005\b\u0003ScC\u0011AAV\u0003\r\tG\r\u001a\u000b\n\u0015\u00065\u0016qVAY\u0003gC\u0001\"a!\u0002(\u0002\u0007\u0011Q\u0011\u0005\t\u0003\u001b\u000b9\u000b1\u0001\u0002\u0010\"9\u0011\u0011DAT\u0001\u0004i\u0004\u0002CA\u000f\u0003O\u0003\r!!\u0001\t\u000f\u0005]F\u0006\"\u0003\u0002:\u0006)\u0001O]5oiR9!*a/\u0002>\u0006}\u0006\u0002CAB\u0003k\u0003\r!!\"\t\u0011\u00055\u0015Q\u0017a\u0001\u0003\u001fC\u0001\"!1\u00026\u0002\u0007\u0011qK\u0001\u0002m\"9\u0011\u0011\u0002\u0017\u0005\u0002\u0005\u0015G#B@\u0002H\u0006%\u0007\u0002CAB\u0003\u0007\u0004\r!!\"\t\u0011\u00055\u00151\u0019a\u0001\u0003\u001fCq!a\u000b-\t\u0003\ti\rF\u0003s\u0003\u001f\f\t\u000e\u0003\u0005\u0002\u0004\u0006-\u0007\u0019AAC\u0011!\ti)a3A\u0002\u0005=\u0005bBAk\u001b\u0001\u0006I\u0001H\u0001\u0007i\u0006\u0014G.\u001a\u0011\t\u000f\u0005eW\u0002\"\u0001\u0002\\\u0006!q\u000e]3o)\rY\u0013Q\u001c\u0005\u0007-\u0006]\u0007\u0019\u0001\u0013\t\u0013\u0005\u0005X\"%A\u0005\u0002\u0005\r\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002f*\u001aQ(a:,\u0005\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a=\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\fiOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class IndexFile
implements IClose {
    private int refrence = 0;
    private final int MB;
    private final String path;
    private final MemHashBlock hashFile;
    private final KeyDataFile keyFile;

    public static int $lessinit$greater$default$2() {
        return IndexFile$.MODULE$.$lessinit$greater$default$2();
    }

    public static IndexFile open(String string) {
        return IndexFile$.MODULE$.open(string);
    }

    public static Hashtable<String, IndexFile> table() {
        return IndexFile$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public int MB() {
        return this.MB;
    }

    public String path() {
        return this.path;
    }

    public MemHashBlock hashFile() {
        return this.hashFile;
    }

    public KeyDataFile keyFile() {
        return this.keyFile;
    }

    public synchronized boolean put(byte[] key, float[] value) {
        if (key == null || value == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        pos = this.keyFile().append(pos, key, value);
        this.hashFile().put(keyHash, pos);
        return true;
    }

    public float[] get(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getKey(pos), key)) {
                return this.keyFile().getValue(pos);
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return null;
    }

    public float updateAdd(byte[] key, int hhmm, float cnt) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getKey(pos), key)) {
                return this.keyFile().updateAdd(pos, hhmm, cnt);
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return 0.0f;
    }

    public void update(byte[] key, float[] value) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getKey(pos), key)) {
                this.keyFile().update(pos, value);
                return;
            }
            pos = this.keyFile().getHashLink(pos);
        }
    }

    public boolean hasKey(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getKey(pos), key)) {
                return true;
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return false;
    }

    public List<float[]> getAll(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        ArrayList<float[]> out = new ArrayList<float[]>();
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            Object object = !this.keyFile().isDeleted(pos) ? (CompareUtil.equals(okey = this.keyFile().getKey(pos), key) ? BoxesRunTime.boxToBoolean((boolean)out.add(this.keyFile().getValue(pos))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            pos = this.keyFile().getHashLink(pos);
        }
        return out;
    }

    public int delete(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashFile().get(keyHash);
        int deleted = 0;
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getKey(pos), key)) {
                this.keyFile().setDelete(pos, true);
                ++deleted;
            }
            pos = this.keyFile().getHashLink(pos);
        }
        return deleted;
    }

    public boolean read(Function2<byte[], int[], Object> handler) {
        if (this.keyFile() == null) {
            return false;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                KeyDataFile.ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() && r.key().length > 0 ? handler.apply((Object)r.key(), (Object)r.value()) : BoxedUnit.UNIT;
                ++done;
                pos = r.next();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S184", new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.keyFile()), " : read=")).append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
        return true;
    }

    public Map<String, Number> getStat() {
        int deleted = 0;
        int count = 0;
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        while (pos < length && pos > 0L) {
            KeyDataFile.ITEM r = this.keyFile().getRecord(pos);
            if (r.deleted()) {
                ++deleted;
            } else {
                ++count;
            }
            pos = r.next();
        }
        int scatter = this.hashFile().getCount();
        HashMap<String, Number> out = new HashMap<String, Number>();
        out.put("count", Predef$.MODULE$.int2Integer(count));
        out.put("scatter", Predef$.MODULE$.int2Integer(scatter));
        out.put("deleted", Predef$.MODULE$.int2Integer(deleted));
        out.put("scan", Predef$.MODULE$.int2Integer((count + deleted) / scatter));
        return out;
    }

    private void _close() {
        this.hashFile().close();
        this.keyFile().close();
    }

    @Override
    public void close() {
        Hashtable<String, IndexFile> hashtable = IndexFile$.MODULE$.table();
        synchronized (hashtable) {
            IndexFile indexFile;
            if (this.refrence() == 0) {
                this._close();
                indexFile = IndexFile$.MODULE$.table().remove(this.path());
            } else {
                this.refrence_$eq(this.refrence() - 1);
                indexFile = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void set(long tagKey, Value tagValue, float[] value) {
        IndexFile indexFile = this;
        synchronized (indexFile) {
            DataOutputX key = new DataOutputX();
            key.writeLong(tagKey);
            key.writeValue(tagValue);
            BoxesRunTime.boxToBoolean((boolean)this.put(key.toByteArray(), value));
            return;
        }
    }

    public void update(long tagKey, Value tagValue, float[] value) {
        IndexFile indexFile = this;
        synchronized (indexFile) {
            this.liftedTree1$1(tagKey, tagValue, value);
            return;
        }
    }

    public void add(long tagKey, Value tagValue, int hhmm, float cnt) {
        IndexFile indexFile = this;
        synchronized (indexFile) {
            this.liftedTree2$1(tagKey, tagValue, hhmm, cnt);
            return;
        }
    }

    private void print(long tagKey, Value tagValue, int[] v) {
        System.out.print(new StringBuilder().append((Object)" ").append((Object)BoxesRunTime.boxToLong((long)tagKey)).append((Object)"  ").append((Object)tagValue).toString());
        int i = 0;
        while (i < v.length) {
            System.out.print(new StringBuilder().append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)v[i])).toString());
        }
        System.out.println("");
    }

    public synchronized float[] get(long tagKey, Value tagValue) {
        DataOutputX key = new DataOutputX();
        key.writeLong(tagKey);
        key.writeValue(tagValue);
        return this.get(key.toByteArray());
    }

    public synchronized boolean hasKey(long tagKey, Value tagValue) {
        DataOutputX key = new DataOutputX();
        key.writeLong(tagKey);
        key.writeValue(tagValue);
        return this.hasKey(key.toByteArray());
    }

    private final Object liftedTree1$1(long tagKey$1, Value tagValue$1, float[] value$1) {
        Object object;
        try {
            DataOutputX out = new DataOutputX();
            out.writeLong(tagKey$1);
            out.writeValue(tagValue$1);
            byte[] key = out.toByteArray();
            boolean hask = this.hasKey(key);
            if (hask) {
                this.update(key, value$1);
                object = BoxedUnit.UNIT;
            } else {
                object = BoxesRunTime.boxToBoolean((boolean)this.put(key, value$1));
            }
        }
        catch (Throwable throwable) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private final Object liftedTree2$1(long tagKey$2, Value tagValue$2, int hhmm$1, float cnt$1) {
        Object object;
        try {
            DataOutputX out = new DataOutputX();
            out.writeLong(tagKey$2);
            out.writeValue(tagValue$2);
            byte[] key = out.toByteArray();
            boolean hask = this.hasKey(key);
            if (hask) {
                object = BoxesRunTime.boxToFloat((float)this.updateAdd(key, hhmm$1, cnt$1));
            } else {
                int x = TagCountUtil$.MODULE$.getBucketPos(hhmm$1);
                float[] data = new float[TagCountUtil$.MODULE$.BUCKET_SIZE()];
                data[x] = cnt$1;
                object = BoxesRunTime.boxToBoolean((boolean)this.put(key, data));
            }
        }
        catch (Throwable throwable) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public IndexFile(String _path, int hashSize) {
        this.MB = 0x100000;
        this.path = _path;
        this.hashFile = new MemHashBlock(this.path(), hashSize * this.MB());
        this.keyFile = new KeyDataFile(this.path());
    }
}

