/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.ThreadUtil;

public class BackJob
extends Thread {
    private static BackJob instance = null;
    private StringKeyLinkedMap<Job> jobTable = new StringKeyLinkedMap().setMax(1000);

    public static final synchronized BackJob getInstance() {
        if (instance == null) {
            instance = new BackJob();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public void add(String name, long tm, Runnable r) {
        this.jobTable.put(name, new Job(tm, r));
    }

    public void remove(String name) {
        this.jobTable.remove(name);
    }

    @Override
    public void run() {
        block2: while (true) {
            ThreadUtil.sleep(1000L);
            long now = System.currentTimeMillis();
            StringEnumer en = this.jobTable.keys();
            while (true) {
                if (!en.hasMoreElements()) continue block2;
                String name = en.nextString();
                try {
                    Job job = this.jobTable.get(name);
                    if (now >= job.nextExecTime) {
                        job.nextExecTime = job.interval + System.currentTimeMillis();
                    }
                    job.run.run();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            break;
        }
    }

    private static class Job {
        long interval;
        long nextExecTime;
        Runnable run;

        public Job(long interval, Runnable run2) {
            this.interval = interval;
            this.run = run2;
        }
    }
}

