/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.XLogPack;
import scouter.util.IntSet;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;
import scouterx.webapp.model.XLogPackWrapper;

public class XLogLoopCache {
    private static final Logger log = LoggerFactory.getLogger(XLogLoopCache.class);
    private static final Map<Integer, XLogLoopCache> loopCacheMap = new HashMap<Integer, XLogLoopCache>();
    private static ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private final int MAX_RETRIEVE_COUNT;
    private final Server server;
    private long loop = 0L;
    private int index = 0;
    private final XLogPackWrapper[] queue;

    public XLogLoopCache(Server server, int capacity) {
        this.MAX_RETRIEVE_COUNT = capacity / 2;
        this.server = server;
        if (server == null) {
            throw new RuntimeException("Not yet initialized!");
        }
        this.queue = new XLogPackWrapper[capacity];
        loopCacheMap.put(server.getId(), this);
    }

    public static XLogLoopCache getOf(int serverId) {
        return loopCacheMap.get(serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(XLogPack pack) {
        if (conf.isTrace() && this.index % 10000 == 0) {
            log.info("XLog added - {} {} {}", new Object[]{this.loop, this.index, pack});
        }
        XLogPackWrapper[] xLogPackWrapperArray = this.queue;
        synchronized (this.queue) {
            this.queue[this.index] = new XLogPackWrapper(pack, this.loop, this.index);
            ++this.index;
            if (this.index >= this.queue.length) {
                ++this.loop;
                this.index = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void getAndHandleRealTimeXLog(long aLoop, int aIndex, int aMaxCount, long bufferTime, Consumer<XLogPackWrapper> handlerConsumer) {
        this.getAndHandleRealTimeXLog(null, aLoop, aIndex, aMaxCount, bufferTime, handlerConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndHandleRealTimeXLog(IntSet objHashIntSet, long aLoop, int aIndex, int aMaxCount, long bufferTime, Consumer<XLogPackWrapper> handlerConsumer) {
        int maxCount = aMaxCount;
        if ((aLoop != 0L || aIndex != 0) && ++aIndex >= this.queue.length) {
            aIndex = 0;
            ++aLoop;
        }
        XLogPackWrapper[] xLogPackWrapperArray = this.queue;
        synchronized (this.queue) {
            long currentLoop = this.loop;
            int currentIndex = this.index;
            // ** MonitorExit[var13_8] (shouldn't be in output)
            int loopStatus = (int)(currentLoop - aLoop);
            switch (loopStatus) {
                case 0: {
                    int countToGet = currentIndex - aIndex;
                    if (aIndex < currentIndex) {
                        maxCount = Math.min(aMaxCount, countToGet);
                        break;
                    }
                    return;
                }
                case 1: {
                    maxCount = Math.min(aMaxCount, this.queue.length - aIndex + currentIndex);
                    break;
                }
            }
            if (maxCount == 0 || maxCount > this.MAX_RETRIEVE_COUNT) {
                maxCount = this.MAX_RETRIEVE_COUNT;
            }
            if (maxCount > currentIndex) {
                this.handleInternal(objHashIntSet, this.queue.length - (maxCount - currentIndex), this.queue.length, bufferTime, handlerConsumer);
                this.handleInternal(objHashIntSet, 0, currentIndex, bufferTime, handlerConsumer);
            } else {
                this.handleInternal(objHashIntSet, currentIndex - maxCount, currentIndex, bufferTime, handlerConsumer);
            }
            return;
        }
    }

    private void handleInternal(IntSet objHashIntSet, int from, int to, long bufferTime, Consumer<XLogPackWrapper> handlerConsumer) {
        long now = this.server.getCurrentTime();
        for (int i = from; i < to; ++i) {
            XLogPackWrapper packWrapper = this.queue[i];
            if (now - bufferTime < packWrapper.getPack().endTime) break;
            if (objHashIntSet != null && objHashIntSet.size() > 0 && !objHashIntSet.contains(packWrapper.getPack().objHash)) continue;
            handlerConsumer.accept(packWrapper);
        }
    }
}

