/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import scouterx.webapp.layer.service.SummaryService;
import scouterx.webapp.model.summary.AlertSummaryItem;
import scouterx.webapp.model.summary.ApiCallSummaryItem;
import scouterx.webapp.model.summary.ErrorSummaryItem;
import scouterx.webapp.model.summary.IpSummaryItem;
import scouterx.webapp.model.summary.ServiceSummaryItem;
import scouterx.webapp.model.summary.SqlSummaryItem;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.UserAgentSummaryItem;
import scouterx.webapp.request.SummaryOfObjHashRequest;
import scouterx.webapp.request.SummaryOfObjTypeRequest;
import scouterx.webapp.request.SummaryRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/summary")
@Api(value="Summary")
@Singleton
@Produces(value={"application/json"})
public class SummaryController {
    private final SummaryService summaryService = new SummaryService();
    private final String NOTE_retrieveServiceSummaryByType = "* retrieve service summary data (5min precision) of specific object type within given duration.\n  * uri pattern : /summary/service/ofType/{objType}?startTimeMillis={startTimeMillis}&endTimeMillis={endTimeMillis}&serverId={serverId}\n  * uri pattern : /summary/service/ofType/{objType}?startYmdHm={startYmdHm}&endYmdHm={endYmdHm}&serverId={serverId}";

    @GET
    @Path(value="/service/ofType/{objType}")
    @ApiOperation(value="retrieveServiceSummaryByType", notes="* retrieve service summary data (5min precision) of specific object type within given duration.\n  * uri pattern : /summary/service/ofType/{objType}?startTimeMillis={startTimeMillis}&endTimeMillis={endTimeMillis}&serverId={serverId}\n  * uri pattern : /summary/service/ofType/{objType}?startYmdHm={startYmdHm}&endYmdHm={endYmdHm}&serverId={serverId}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ServiceSummaryItem>> retrieveServiceSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveServiceSummary(request);
    }

    @GET
    @Path(value="/service/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ServiceSummaryItem>> retrieveServiceSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveServiceSummary(request);
    }

    private CommonResultView<Summary<ServiceSummaryItem>> retrieveServiceSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveServiceSummary(request));
    }

    @GET
    @Path(value="/sql/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<SqlSummaryItem>> retrieveSqlSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveSqlSummary(request);
    }

    @GET
    @Path(value="/sql/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<SqlSummaryItem>> retrieveSqlSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveSqlSummary(request);
    }

    private CommonResultView<Summary<SqlSummaryItem>> retrieveSqlSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveSqlSummary(request));
    }

    @GET
    @Path(value="/apiCall/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ApiCallSummaryItem>> retrieveApiCallSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveApiCallSummary(request);
    }

    @GET
    @Path(value="/apiCall/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ApiCallSummaryItem>> retrieveApiCallSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveApiCallSummary(request);
    }

    private CommonResultView<Summary<ApiCallSummaryItem>> retrieveApiCallSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveApiCallSummary(request));
    }

    @GET
    @Path(value="/ip/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<IpSummaryItem>> retrieveIpSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveIpSummary(request);
    }

    @GET
    @Path(value="/ip/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<IpSummaryItem>> retrieveIpSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveIpSummary(request);
    }

    private CommonResultView<Summary<IpSummaryItem>> retrieveIpSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveIpSummary(request));
    }

    @GET
    @Path(value="/userAgent/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<UserAgentSummaryItem>> retrieveUserAgentSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveUserAgentSummary(request);
    }

    @GET
    @Path(value="/userAgent/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<UserAgentSummaryItem>> retrieveUserAgentSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveUserAgentSummary(request);
    }

    private CommonResultView<Summary<UserAgentSummaryItem>> retrieveUserAgentSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveUserAgentSummary(request));
    }

    @GET
    @Path(value="/error/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ErrorSummaryItem>> retrieveErrorSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveErrorSummary(request);
    }

    @GET
    @Path(value="/error/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<ErrorSummaryItem>> retrieveErrorSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveErrorSummary(request);
    }

    private CommonResultView<Summary<ErrorSummaryItem>> retrieveErrorSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveErrorSummary(request));
    }

    @GET
    @Path(value="/alert/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<AlertSummaryItem>> retrieveAlertSummaryByType(@BeanParam @Valid SummaryOfObjTypeRequest request) {
        return this.retrieveAlertSummary(request);
    }

    @GET
    @Path(value="/alert/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<Summary<AlertSummaryItem>> retrieveAlertSummaryByObj(@BeanParam @Valid SummaryOfObjHashRequest request) {
        return this.retrieveAlertSummary(request);
    }

    private CommonResultView<Summary<AlertSummaryItem>> retrieveAlertSummary(SummaryRequest request) {
        request.validate();
        return CommonResultView.success(this.summaryService.retrieveAlertSummary(request));
    }
}

