/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import com.fasterxml.jackson.core.JsonGenerator;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouterx.webapp.framework.client.net.INetReader;
import scouterx.webapp.layer.service.XLogService;
import scouterx.webapp.model.scouter.SXLog;
import scouterx.webapp.request.GxidXLogRequest;
import scouterx.webapp.request.PageableXLogRequest;
import scouterx.webapp.request.RealTimeXLogRequest;
import scouterx.webapp.request.SearchXLogRequest;
import scouterx.webapp.request.SingleXLogRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/xlog")
@Api(value="Raw xlog")
@Singleton
@Produces(value={"application/json"})
public class XLogController {
    private static final Logger log = LoggerFactory.getLogger(XLogController.class);
    private final XLogService xLogService = new XLogService();

    @GET
    @Path(value="/realTime/{xlogLoop}/{xlogIndex}")
    public Response streamRealTimeXLog(@BeanParam @Valid RealTimeXLogRequest xLogRequest) {
        Consumer<JsonGenerator> realTimeXLogHandlerConsumer = jsonGenerator -> {
            try {
                int[] countable = new int[]{0};
                INetReader xLogReader = this.getRealTimeXLogReader((JsonGenerator)jsonGenerator, countable);
                this.xLogService.handleRealTimeXLog(xLogRequest, xLogReader);
                jsonGenerator.writeEndArray();
                jsonGenerator.writeNumberField("count", countable[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        StreamingOutput streamingOutput = outputStream -> CommonResultView.jsonStream(outputStream, realTimeXLogHandlerConsumer);
        return Response.ok().entity((Object)streamingOutput).type("application/json").build();
    }

    @GET
    @Path(value="/{yyyymmdd}")
    @Consumes(value={"application/json"})
    public Response streamPageableXLog(@Valid @BeanParam PageableXLogRequest xLogRequest) {
        xLogRequest.validate();
        Consumer<JsonGenerator> pageableXLogHandlerConsumer = jsonGenerator -> {
            try {
                jsonGenerator.writeArrayFieldStart("xlogs");
                this.xLogService.handlePageableXLog(xLogRequest, this.getPageableXLogReader((JsonGenerator)jsonGenerator));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        StreamingOutput streamingOutput = outputStream -> CommonResultView.jsonStream(outputStream, pageableXLogHandlerConsumer);
        return Response.ok().entity((Object)streamingOutput).type("application/json").build();
    }

    @GET
    @Path(value="/{yyyymmdd}/{txid}")
    @Consumes(value={"application/json"})
    public CommonResultView<SXLog> retrieveSingleXLog(@Valid @BeanParam SingleXLogRequest singleXlogRequest) {
        singleXlogRequest.validate();
        SXLog xLog = this.xLogService.retrieveSingleXLog(singleXlogRequest);
        return CommonResultView.success(xLog);
    }

    @GET
    @Path(value="/{yyyymmdd}/gxid/{gxid}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SXLog>> retrieveXLogsByGxid(@Valid @BeanParam GxidXLogRequest gxidRequest) {
        gxidRequest.validate();
        List<SXLog> xLogs = this.xLogService.retrieveXLogListByGxid(gxidRequest);
        return CommonResultView.success(xLogs);
    }

    @GET
    @Path(value="/search/{yyyymmdd}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SXLog>> searchXLog(@Valid @BeanParam SearchXLogRequest xLogRequest) throws ParseException {
        xLogRequest.validate();
        List<SXLog> list = this.xLogService.searchXLogList(xLogRequest);
        return CommonResultView.success(list);
    }

    private INetReader getRealTimeXLogReader(JsonGenerator jsonGenerator, int[] countable) {
        return in -> {
            Pack p = in.readPack();
            if (p.getPackType() == 10) {
                MapPack metaPack = (MapPack)p;
                jsonGenerator.writeNumberField("xlogLoop", metaPack.getInt("loop"));
                jsonGenerator.writeNumberField("xlogIndex", metaPack.getInt("index"));
                jsonGenerator.writeArrayFieldStart("xlogs");
            } else {
                XLogPack xLogPack = (XLogPack)p;
                jsonGenerator.writeObject((Object)SXLog.of(xLogPack));
                countable[0] = countable[0] + 1;
            }
        };
    }

    private INetReader getPageableXLogReader(JsonGenerator jsonGenerator) {
        int[] countable = new int[]{0};
        return in -> {
            Pack p = in.readPack();
            if (p.getPackType() != 10) {
                XLogPack xLogPack = (XLogPack)p;
                jsonGenerator.writeObject((Object)SXLog.of(xLogPack));
                countable[0] = countable[0] + 1;
            } else {
                jsonGenerator.writeEndArray();
                MapPack metaPack = (MapPack)p;
                jsonGenerator.writeBooleanField("hasMore", metaPack.getBoolean("hasMore"));
                jsonGenerator.writeNumberField("lastTxid", metaPack.getLong("lastTxid"));
                jsonGenerator.writeNumberField("lastXLogTime", metaPack.getLong("lastXLogTime"));
                jsonGenerator.writeNumberField("count", countable[0]);
            }
        };
    }
}

