/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.beans.ConstructorProperties;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogTypes;
import scouterx.webapp.framework.client.model.TextLoader;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.client.model.TextTypeEnum;
import scouterx.webapp.framework.util.ZZ;

public class XLogData {
    private long endTime;
    private int objHash;
    private String service;
    private long txid;
    private String threadName;
    private long caller;
    private long gxid;
    private int elapsed;
    private String error;
    private int cpu;
    private int sqlCount;
    private int sqlTime;
    private String ipAddr;
    private int allocatedMemory;
    private long internalId;
    private String userAgent;
    private String referrer;
    private String group;
    private int apicallCount;
    private int apicallTime;
    private String countryCode;
    private String city;
    private String xLogType;
    private String login;
    private String desc;
    private byte hasDump;
    private String text1;
    private String text2;
    private String text3;
    private String text4;
    private String text5;
    private String queuingHost;
    private int queuingTime;
    private String queuing2ndHost;
    private int queuing2ndTime;

    public static XLogData of(XLogPack p, int serverId) {
        XLogData.preLoadDictionary(p, serverId);
        return XLogData.builder().endTime(p.endTime).objHash(p.objHash).service(TextProxy.service.getCachedTextIfNullDefault(p.service)).txid(p.txid).threadName(TextProxy.hashMessage.getCachedTextIfNullDefault(p.threadNameHash)).caller(p.caller).gxid(p.gxid).elapsed(p.elapsed).error(TextProxy.error.getCachedTextIfNullDefault(p.error)).cpu(p.cpu).sqlCount(p.sqlCount).sqlTime(p.sqlTime).ipAddr(ZZ.ipByteToString(p.ipaddr)).allocatedMemory(p.kbytes).internalId(p.userid).userAgent(TextProxy.userAgent.getCachedTextIfNullDefault(p.userAgent)).referrer(TextProxy.referrer.getCachedTextIfNullDefault(p.referer)).group(TextProxy.group.getCachedTextIfNullDefault(p.group)).apicallCount(p.apicallCount).apicallTime(p.apicallTime).countryCode(p.countryCode).city(TextProxy.city.getCachedTextIfNullDefault(p.city)).xLogType(XLogTypes.Type.of((byte)p.xType).name()).login(TextProxy.login.getCachedTextIfNullDefault(p.login)).desc(TextProxy.desc.getCachedTextIfNullDefault(p.desc)).hasDump(p.hasDump).text1(p.text1).text2(p.text2).text3(p.text3).text4(p.text4).text5(p.text5).queuingHost(TextProxy.hashMessage.getCachedTextIfNullDefault(p.queuingHostHash)).queuingTime(p.queuingTime).queuing2ndHost(TextProxy.hashMessage.getCachedTextIfNullDefault(p.queuing2ndHostHash)).queuing2ndTime(p.queuing2ndTime).build();
    }

    private static void preLoadDictionary(XLogPack pack, int serverId) {
        TextLoader loader = new TextLoader(serverId);
        loader.addTextHash(TextTypeEnum.SERVICE, pack.service);
        loader.addTextHash(TextTypeEnum.HASH_MSG, pack.threadNameHash);
        loader.addTextHash(TextTypeEnum.ERROR, pack.error);
        loader.addTextHash(TextTypeEnum.USER_AGENT, pack.userAgent);
        loader.addTextHash(TextTypeEnum.REFERRER, pack.referer);
        loader.addTextHash(TextTypeEnum.GROUP, pack.group);
        loader.addTextHash(TextTypeEnum.CITY, pack.city);
        loader.addTextHash(TextTypeEnum.LOGIN, pack.login);
        loader.addTextHash(TextTypeEnum.DESC, pack.desc);
        loader.addTextHash(TextTypeEnum.HASH_MSG, pack.queuingHostHash);
        loader.addTextHash(TextTypeEnum.HASH_MSG, pack.queuing2ndHostHash);
        loader.loadAll();
    }

    @ConstructorProperties(value={"endTime", "objHash", "service", "txid", "threadName", "caller", "gxid", "elapsed", "error", "cpu", "sqlCount", "sqlTime", "ipAddr", "allocatedMemory", "internalId", "userAgent", "referrer", "group", "apicallCount", "apicallTime", "countryCode", "city", "xLogType", "login", "desc", "hasDump", "text1", "text2", "text3", "text4", "text5", "queuingHost", "queuingTime", "queuing2ndHost", "queuing2ndTime"})
    XLogData(long endTime, int objHash, String service, long txid, String threadName, long caller, long gxid, int elapsed, String error, int cpu, int sqlCount, int sqlTime, String ipAddr, int allocatedMemory, long internalId, String userAgent, String referrer, String group, int apicallCount, int apicallTime, String countryCode, String city, String xLogType, String login, String desc, byte hasDump, String text1, String text2, String text3, String text4, String text5, String queuingHost, int queuingTime, String queuing2ndHost, int queuing2ndTime) {
        this.endTime = endTime;
        this.objHash = objHash;
        this.service = service;
        this.txid = txid;
        this.threadName = threadName;
        this.caller = caller;
        this.gxid = gxid;
        this.elapsed = elapsed;
        this.error = error;
        this.cpu = cpu;
        this.sqlCount = sqlCount;
        this.sqlTime = sqlTime;
        this.ipAddr = ipAddr;
        this.allocatedMemory = allocatedMemory;
        this.internalId = internalId;
        this.userAgent = userAgent;
        this.referrer = referrer;
        this.group = group;
        this.apicallCount = apicallCount;
        this.apicallTime = apicallTime;
        this.countryCode = countryCode;
        this.city = city;
        this.xLogType = xLogType;
        this.login = login;
        this.desc = desc;
        this.hasDump = hasDump;
        this.text1 = text1;
        this.text2 = text2;
        this.text3 = text3;
        this.text4 = text4;
        this.text5 = text5;
        this.queuingHost = queuingHost;
        this.queuingTime = queuingTime;
        this.queuing2ndHost = queuing2ndHost;
        this.queuing2ndTime = queuing2ndTime;
    }

    public static XLogDataBuilder builder() {
        return new XLogDataBuilder();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getService() {
        return this.service;
    }

    public long getTxid() {
        return this.txid;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getCaller() {
        return this.caller;
    }

    public long getGxid() {
        return this.gxid;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public String getError() {
        return this.error;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getSqlCount() {
        return this.sqlCount;
    }

    public int getSqlTime() {
        return this.sqlTime;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public int getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getGroup() {
        return this.group;
    }

    public int getApicallCount() {
        return this.apicallCount;
    }

    public int getApicallTime() {
        return this.apicallTime;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getXLogType() {
        return this.xLogType;
    }

    public String getLogin() {
        return this.login;
    }

    public String getDesc() {
        return this.desc;
    }

    public byte getHasDump() {
        return this.hasDump;
    }

    public String getText1() {
        return this.text1;
    }

    public String getText2() {
        return this.text2;
    }

    public String getText3() {
        return this.text3;
    }

    public String getText4() {
        return this.text4;
    }

    public String getText5() {
        return this.text5;
    }

    public String getQueuingHost() {
        return this.queuingHost;
    }

    public int getQueuingTime() {
        return this.queuingTime;
    }

    public String getQueuing2ndHost() {
        return this.queuing2ndHost;
    }

    public int getQueuing2ndTime() {
        return this.queuing2ndTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setObjHash(int objHash) {
        this.objHash = objHash;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setTxid(long txid) {
        this.txid = txid;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setCaller(long caller) {
        this.caller = caller;
    }

    public void setGxid(long gxid) {
        this.gxid = gxid;
    }

    public void setElapsed(int elapsed) {
        this.elapsed = elapsed;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    public void setSqlCount(int sqlCount) {
        this.sqlCount = sqlCount;
    }

    public void setSqlTime(int sqlTime) {
        this.sqlTime = sqlTime;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public void setAllocatedMemory(int allocatedMemory) {
        this.allocatedMemory = allocatedMemory;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setApicallCount(int apicallCount) {
        this.apicallCount = apicallCount;
    }

    public void setApicallTime(int apicallTime) {
        this.apicallTime = apicallTime;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setXLogType(String xLogType) {
        this.xLogType = xLogType;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setHasDump(byte hasDump) {
        this.hasDump = hasDump;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }

    public void setText5(String text5) {
        this.text5 = text5;
    }

    public void setQueuingHost(String queuingHost) {
        this.queuingHost = queuingHost;
    }

    public void setQueuingTime(int queuingTime) {
        this.queuingTime = queuingTime;
    }

    public void setQueuing2ndHost(String queuing2ndHost) {
        this.queuing2ndHost = queuing2ndHost;
    }

    public void setQueuing2ndTime(int queuing2ndTime) {
        this.queuing2ndTime = queuing2ndTime;
    }

    public static class XLogDataBuilder {
        private long endTime;
        private int objHash;
        private String service;
        private long txid;
        private String threadName;
        private long caller;
        private long gxid;
        private int elapsed;
        private String error;
        private int cpu;
        private int sqlCount;
        private int sqlTime;
        private String ipAddr;
        private int allocatedMemory;
        private long internalId;
        private String userAgent;
        private String referrer;
        private String group;
        private int apicallCount;
        private int apicallTime;
        private String countryCode;
        private String city;
        private String xLogType;
        private String login;
        private String desc;
        private byte hasDump;
        private String text1;
        private String text2;
        private String text3;
        private String text4;
        private String text5;
        private String queuingHost;
        private int queuingTime;
        private String queuing2ndHost;
        private int queuing2ndTime;

        XLogDataBuilder() {
        }

        public XLogDataBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public XLogDataBuilder objHash(int objHash) {
            this.objHash = objHash;
            return this;
        }

        public XLogDataBuilder service(String service) {
            this.service = service;
            return this;
        }

        public XLogDataBuilder txid(long txid) {
            this.txid = txid;
            return this;
        }

        public XLogDataBuilder threadName(String threadName) {
            this.threadName = threadName;
            return this;
        }

        public XLogDataBuilder caller(long caller) {
            this.caller = caller;
            return this;
        }

        public XLogDataBuilder gxid(long gxid) {
            this.gxid = gxid;
            return this;
        }

        public XLogDataBuilder elapsed(int elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public XLogDataBuilder error(String error) {
            this.error = error;
            return this;
        }

        public XLogDataBuilder cpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        public XLogDataBuilder sqlCount(int sqlCount) {
            this.sqlCount = sqlCount;
            return this;
        }

        public XLogDataBuilder sqlTime(int sqlTime) {
            this.sqlTime = sqlTime;
            return this;
        }

        public XLogDataBuilder ipAddr(String ipAddr) {
            this.ipAddr = ipAddr;
            return this;
        }

        public XLogDataBuilder allocatedMemory(int allocatedMemory) {
            this.allocatedMemory = allocatedMemory;
            return this;
        }

        public XLogDataBuilder internalId(long internalId) {
            this.internalId = internalId;
            return this;
        }

        public XLogDataBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public XLogDataBuilder referrer(String referrer) {
            this.referrer = referrer;
            return this;
        }

        public XLogDataBuilder group(String group) {
            this.group = group;
            return this;
        }

        public XLogDataBuilder apicallCount(int apicallCount) {
            this.apicallCount = apicallCount;
            return this;
        }

        public XLogDataBuilder apicallTime(int apicallTime) {
            this.apicallTime = apicallTime;
            return this;
        }

        public XLogDataBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public XLogDataBuilder city(String city) {
            this.city = city;
            return this;
        }

        public XLogDataBuilder xLogType(String xLogType) {
            this.xLogType = xLogType;
            return this;
        }

        public XLogDataBuilder login(String login) {
            this.login = login;
            return this;
        }

        public XLogDataBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public XLogDataBuilder hasDump(byte hasDump) {
            this.hasDump = hasDump;
            return this;
        }

        public XLogDataBuilder text1(String text1) {
            this.text1 = text1;
            return this;
        }

        public XLogDataBuilder text2(String text2) {
            this.text2 = text2;
            return this;
        }

        public XLogDataBuilder text3(String text3) {
            this.text3 = text3;
            return this;
        }

        public XLogDataBuilder text4(String text4) {
            this.text4 = text4;
            return this;
        }

        public XLogDataBuilder text5(String text5) {
            this.text5 = text5;
            return this;
        }

        public XLogDataBuilder queuingHost(String queuingHost) {
            this.queuingHost = queuingHost;
            return this;
        }

        public XLogDataBuilder queuingTime(int queuingTime) {
            this.queuingTime = queuingTime;
            return this;
        }

        public XLogDataBuilder queuing2ndHost(String queuing2ndHost) {
            this.queuing2ndHost = queuing2ndHost;
            return this;
        }

        public XLogDataBuilder queuing2ndTime(int queuing2ndTime) {
            this.queuing2ndTime = queuing2ndTime;
            return this;
        }

        public XLogData build() {
            return new XLogData(this.endTime, this.objHash, this.service, this.txid, this.threadName, this.caller, this.gxid, this.elapsed, this.error, this.cpu, this.sqlCount, this.sqlTime, this.ipAddr, this.allocatedMemory, this.internalId, this.userAgent, this.referrer, this.group, this.apicallCount, this.apicallTime, this.countryCode, this.city, this.xLogType, this.login, this.desc, this.hasDump, this.text1, this.text2, this.text3, this.text4, this.text5, this.queuingHost, this.queuingTime, this.queuing2ndHost, this.queuing2ndTime);
        }

        public String toString() {
            return "XLogData.XLogDataBuilder(endTime=" + this.endTime + ", objHash=" + this.objHash + ", service=" + this.service + ", txid=" + this.txid + ", threadName=" + this.threadName + ", caller=" + this.caller + ", gxid=" + this.gxid + ", elapsed=" + this.elapsed + ", error=" + this.error + ", cpu=" + this.cpu + ", sqlCount=" + this.sqlCount + ", sqlTime=" + this.sqlTime + ", ipAddr=" + this.ipAddr + ", allocatedMemory=" + this.allocatedMemory + ", internalId=" + this.internalId + ", userAgent=" + this.userAgent + ", referrer=" + this.referrer + ", group=" + this.group + ", apicallCount=" + this.apicallCount + ", apicallTime=" + this.apicallTime + ", countryCode=" + this.countryCode + ", city=" + this.city + ", xLogType=" + this.xLogType + ", login=" + this.login + ", desc=" + this.desc + ", hasDump=" + this.hasDump + ", text1=" + this.text1 + ", text2=" + this.text2 + ", text3=" + this.text3 + ", text4=" + this.text4 + ", text5=" + this.text5 + ", queuingHost=" + this.queuingHost + ", queuingTime=" + this.queuingTime + ", queuing2ndHost=" + this.queuing2ndHost + ", queuing2ndTime=" + this.queuing2ndTime + ")";
        }
    }
}

