/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class ErrorSummaryItem
extends SummaryItem<ErrorSummaryItem> {
    private String error;
    private String service;
    private String errorMessage;
    private long txid;
    private String sql;
    private String apiCall;
    private String fullStack;

    public ErrorSummaryItem(int summaryKey, String summaryKeyName, int count, String error, String service, String errorMessage, long txid, String sql, String apiCall, String fullStack) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
        this.error = error;
        this.service = service;
        this.errorMessage = errorMessage;
        this.txid = txid;
        this.sql = sql;
        this.apiCall = apiCall;
        this.fullStack = fullStack;
    }

    @Override
    public void merge(ErrorSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
        this.setError(newItem.getError());
        this.setService(newItem.getService());
        this.setErrorMessage(newItem.getErrorMessage());
        this.setTxid(newItem.getTxid());
        this.setSql(newItem.getSql());
        this.setApiCall(newItem.getApiCall());
        this.setFullStack(newItem.getFullStack());
    }

    @Override
    public Summary<ErrorSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<ErrorSummaryItem> summary = new Summary<ErrorSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            ListValue errorList = dnmPack.getMapPack().getList("error");
            ListValue serviceList = dnmPack.getMapPack().getList("service");
            ListValue errorMessageList = dnmPack.getMapPack().getList("message");
            ListValue txidList = dnmPack.getMapPack().getList("txid");
            ListValue sqlList = dnmPack.getMapPack().getList("sql");
            ListValue apiCallList = dnmPack.getMapPack().getList("apicall");
            ListValue fullStackList = dnmPack.getMapPack().getList("fullstack");
            for (int i = 0; i < idList.size(); ++i) {
                String error = TextProxy.error.getTextIfNullDefault(date, errorList.getInt(i), serverId);
                String service = TextProxy.service.getTextIfNullDefault(date, serviceList.getInt(i), serverId);
                ErrorSummaryItem item = ErrorSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(error + " [:of:] " + service).count(countList.getInt(i)).error(error).service(service).errorMessage(TextProxy.error.getTextIfNullDefault(date, errorMessageList.getInt(i), serverId)).txid(txidList.getLong(i)).sql(TextProxy.sql.getTextIfNullDefault(date, sqlList.getInt(i), serverId)).apiCall(TextProxy.apicall.getTextIfNullDefault(date, apiCallList.getInt(i), serverId)).fullStack(TextProxy.error.getTextIfNullDefault(date, fullStackList.getInt(i), serverId)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static ErrorSummaryItemBuilder builder() {
        return new ErrorSummaryItemBuilder();
    }

    public String getError() {
        return this.error;
    }

    public String getService() {
        return this.service;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getTxid() {
        return this.txid;
    }

    public String getSql() {
        return this.sql;
    }

    public String getApiCall() {
        return this.apiCall;
    }

    public String getFullStack() {
        return this.fullStack;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTxid(long txid) {
        this.txid = txid;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setApiCall(String apiCall) {
        this.apiCall = apiCall;
    }

    public void setFullStack(String fullStack) {
        this.fullStack = fullStack;
    }

    @Override
    public String toString() {
        return "ErrorSummaryItem(error=" + this.getError() + ", service=" + this.getService() + ", errorMessage=" + this.getErrorMessage() + ", txid=" + this.getTxid() + ", sql=" + this.getSql() + ", apiCall=" + this.getApiCall() + ", fullStack=" + this.getFullStack() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorSummaryItem)) {
            return false;
        }
        ErrorSummaryItem other = (ErrorSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        if (this.getTxid() != other.getTxid()) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$apiCall = this.getApiCall();
        String other$apiCall = other.getApiCall();
        if (this$apiCall == null ? other$apiCall != null : !this$apiCall.equals(other$apiCall)) {
            return false;
        }
        String this$fullStack = this.getFullStack();
        String other$fullStack = other.getFullStack();
        return !(this$fullStack == null ? other$fullStack != null : !this$fullStack.equals(other$fullStack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ErrorSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        long $txid = this.getTxid();
        result = result * 59 + (int)($txid >>> 32 ^ $txid);
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $apiCall = this.getApiCall();
        result = result * 59 + ($apiCall == null ? 43 : $apiCall.hashCode());
        String $fullStack = this.getFullStack();
        result = result * 59 + ($fullStack == null ? 43 : $fullStack.hashCode());
        return result;
    }

    public ErrorSummaryItem() {
    }

    public static class ErrorSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;
        private String error;
        private String service;
        private String errorMessage;
        private long txid;
        private String sql;
        private String apiCall;
        private String fullStack;

        ErrorSummaryItemBuilder() {
        }

        public ErrorSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public ErrorSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public ErrorSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public ErrorSummaryItemBuilder error(String error) {
            this.error = error;
            return this;
        }

        public ErrorSummaryItemBuilder service(String service) {
            this.service = service;
            return this;
        }

        public ErrorSummaryItemBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ErrorSummaryItemBuilder txid(long txid) {
            this.txid = txid;
            return this;
        }

        public ErrorSummaryItemBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public ErrorSummaryItemBuilder apiCall(String apiCall) {
            this.apiCall = apiCall;
            return this;
        }

        public ErrorSummaryItemBuilder fullStack(String fullStack) {
            this.fullStack = fullStack;
            return this;
        }

        public ErrorSummaryItem build() {
            return new ErrorSummaryItem(this.summaryKey, this.summaryKeyName, this.count, this.error, this.service, this.errorMessage, this.txid, this.sql, this.apiCall, this.fullStack);
        }

        public String toString() {
            return "ErrorSummaryItem.ErrorSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ", error=" + this.error + ", service=" + this.service + ", errorMessage=" + this.errorMessage + ", txid=" + this.txid + ", sql=" + this.sql + ", apiCall=" + this.apiCall + ", fullStack=" + this.fullStack + ")";
        }
    }
}

