/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class SearchXLogRequest {
    int serverId;
    @NotNull
    @PathParam(value="yyyymmdd")
    String yyyymmdd;
    @QueryParam(value="startTimeMillis")
    long startTimeMillis;
    @QueryParam(value="endTimeMillis")
    long endTimeMillis;
    @QueryParam(value="startHms")
    String startHms;
    @QueryParam(value="endHms")
    String endHms;
    @QueryParam(value="objHash")
    long objHash;
    @QueryParam(value="service")
    String service;
    @QueryParam(value="ip")
    String ip;
    @QueryParam(value="login")
    String login;
    @QueryParam(value="desc")
    String desc;
    @QueryParam(value="text1")
    String text1;
    @QueryParam(value="text2")
    String text2;
    @QueryParam(value="text3")
    String text3;
    @QueryParam(value="text4")
    String text4;
    @QueryParam(value="text5")
    String text5;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.startHms) || StringUtils.isNotBlank((CharSequence)this.endHms)) {
            if (StringUtils.isBlank((CharSequence)this.startHms) || StringUtils.isBlank((CharSequence)this.endHms)) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startHms and endHms should be not null !");
            }
            if (this.startTimeMillis > 0L || this.endTimeMillis > 0L) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms, endYmdHms and startTimeMillis, endTimeMills must not coexist!");
            }
            try {
                this.setTimeAsYmd();
            }
            catch (ParseException e) {
                throw ErrorState.VALIDATE_ERROR.newBizException("date is invalid!");
            }
        } else if (this.startTimeMillis <= 0L || this.endTimeMillis <= 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("startTimeMillis and endTimeMillis must have value!");
        }
    }

    private void setTimeAsYmd() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.startTimeMillis = sdf.parse(this.yyyymmdd + this.startHms).getTime();
        this.endTimeMillis = sdf.parse(this.yyyymmdd + this.endHms).getTime();
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getYyyymmdd() {
        return this.yyyymmdd;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public String getStartHms() {
        return this.startHms;
    }

    public String getEndHms() {
        return this.endHms;
    }

    public long getObjHash() {
        return this.objHash;
    }

    public String getService() {
        return this.service;
    }

    public String getIp() {
        return this.ip;
    }

    public String getLogin() {
        return this.login;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getText1() {
        return this.text1;
    }

    public String getText2() {
        return this.text2;
    }

    public String getText3() {
        return this.text3;
    }

    public String getText4() {
        return this.text4;
    }

    public String getText5() {
        return this.text5;
    }

    public void setYyyymmdd(String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public void setStartHms(String startHms) {
        this.startHms = startHms;
    }

    public void setEndHms(String endHms) {
        this.endHms = endHms;
    }

    public void setObjHash(long objHash) {
        this.objHash = objHash;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }

    public void setText5(String text5) {
        this.text5 = text5;
    }

    public String toString() {
        return "SearchXLogRequest(serverId=" + this.getServerId() + ", yyyymmdd=" + this.getYyyymmdd() + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ", startHms=" + this.getStartHms() + ", endHms=" + this.getEndHms() + ", objHash=" + this.getObjHash() + ", service=" + this.getService() + ", ip=" + this.getIp() + ", login=" + this.getLogin() + ", desc=" + this.getDesc() + ", text1=" + this.getText1() + ", text2=" + this.getText2() + ", text3=" + this.getText3() + ", text4=" + this.getText4() + ", text5=" + this.getText5() + ")";
    }
}

