/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.kafka;

import java.util.HashMap;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.kafka.KafkaProducerCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class KafkaProducerASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public KafkaProducerASM() {
        AsmUtil.add(this.reserved, "org.apache.kafka.clients.producer.KafkaProducer", "doSend");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf._hook_kafka_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new KafkaProducerCV(cv, mset, className);
        }
        return cv;
    }
}

