/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request.worker;

import scouter.agent.util.DumpUtil;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public class DumpOnCpuExceedanceWorker
extends Thread {
    private static DumpOnCpuExceedanceWorker instance;
    private RequestQueue<String> queue = new RequestQueue(2);

    public static final synchronized DumpOnCpuExceedanceWorker getInstance() {
        if (instance == null) {
            instance = new DumpOnCpuExceedanceWorker();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public void add(String dumpReason) {
        if (dumpReason == null) {
            this.queue.put("x");
        } else {
            this.queue.put(dumpReason);
        }
    }

    @Override
    public void run() {
        while (true) {
            String reason = this.queue.get();
            try {
                if ("TRIGGER_DUMP_REASON_TYPE_CPU_EXCEEDED".equals(reason)) {
                    DumpUtil.autoDumpByCpuExceedance();
                    continue;
                }
                DumpUtil.triggerThreadDump();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }
}

