/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import org.csstudio.swt.xygraph.Preferences;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.IDataProviderListener;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.IAxisListener;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.csstudio.swt.xygraph.undo.MovingAnnotationCommand;
import org.csstudio.swt.xygraph.undo.MovingAnnotationLabelCommand;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class Annotation
extends Figure
implements IAxisListener,
IDataProviderListener {
    private Axis xAxis;
    private Axis yAxis;
    private String name;
    private FontData fontData;
    private CursorLineStyle cursorLineStyle = CursorLineStyle.NONE;
    private Point currentPosition;
    private double xValue;
    private double yValue;
    private Trace trace;
    private ISample currentSnappedSample;
    private boolean showName = true;
    private boolean showSampleInfo = true;
    private boolean showPosition = true;
    private Color annotationColor = null;
    private RGB annotationColorRGB = null;
    private Label infoLabel;
    private double dx = 40.0;
    private double dy = -40.0;
    private double x0;
    private double y0;
    private boolean knowX0Y0 = false;
    private boolean infoLabelArmed = false;
    private Pointer pointer;
    private XYGraph xyGraph;
    private static final int POINT_SIZE = 6;
    private static final int CURSOR_LINE_LENGTH = 3;
    private static final int ARROW_LINE_LENGTH = 12;
    private boolean pointerDragged;

    public Annotation(String name, Trace trace) {
        this(name, trace.getXAxis(), trace.getYAxis());
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
    }

    public Annotation(String name, Axis xAxis, Axis yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.name = name;
        this.trace = null;
        this.infoLabel = new Label();
        this.infoLabel.setOpaque(false);
        this.infoLabel.setCursor(Cursors.SIZEALL);
        this.add((IFigure)this.infoLabel);
        InfoLabelDragger infoLabelDragger = new InfoLabelDragger();
        this.infoLabel.addMouseMotionListener((MouseMotionListener)infoLabelDragger);
        this.infoLabel.addMouseListener((MouseListener)infoLabelDragger);
        this.pointer = new Pointer();
        this.add((IFigure)this.pointer);
        this.updateToDefaultPosition();
        xAxis.addListener(this);
        yAxis.addListener(this);
    }

    public boolean containsPoint(int x, int y) {
        return this.infoLabel.containsPoint(x, y) || this.pointer.containsPoint(x, y);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        Color tempColor = this.annotationColor == null ? this.yAxis.getForegroundColor() : this.annotationColor;
        this.infoLabel.setForegroundColor(tempColor);
        this.pointer.setForegroundColor(tempColor);
        graphics.setForegroundColor(tempColor);
        Dimension size = this.infoLabel.getPreferredSize();
        this.updateX0Y0Fromdxdy(size);
        Rectangle infoBounds = new Rectangle((int)((double)this.currentPosition.x + this.x0 - (double)size.width / 2.0), (int)((double)this.currentPosition.y + this.y0 - (double)size.height / 2.0), size.width, size.height);
        this.infoLabel.setBounds(infoBounds);
        this.pointer.setBounds(new Rectangle(this.currentPosition.x - 6, this.currentPosition.y - 6, 12, 12));
        if (this.infoLabelArmed) {
            graphics.drawRectangle(infoBounds);
        }
        graphics.drawLine(this.currentPosition.x + (int)this.dx, this.currentPosition.y + (int)this.dy, this.currentPosition.x, this.currentPosition.y);
        int x1 = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
        int y1 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) - 0.3490658503988659));
        if (this.dx < 0.0) {
            x1 = -x1;
            y1 = -y1;
        }
        graphics.drawLine(this.currentPosition.x + x1, this.currentPosition.y - y1, this.currentPosition.x, this.currentPosition.y);
        x1 = (int)(12.0 * Math.cos(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
        y1 = (int)(12.0 * Math.sin(Math.atan(-this.dy / this.dx) + 0.3490658503988659));
        if (this.dx < 0.0) {
            x1 = -x1;
            y1 = -y1;
        }
        graphics.drawLine(this.currentPosition.x + x1, this.currentPosition.y - y1, this.currentPosition.x, this.currentPosition.y);
        switch (this.cursorLineStyle) {
            case NONE: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.currentPosition.x - 3 - 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.currentPosition.x + 3 + 3, this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.currentPosition.y - 3 - 3);
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.currentPosition.y + 3 + 3);
                break;
            }
            case LEFT_RIGHT: 
            case FOUR_DIRECTIONS: {
                graphics.drawLine(this.currentPosition.x - 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getLower(), false), this.currentPosition.y);
                graphics.drawLine(this.currentPosition.x + 3, this.currentPosition.y, this.xAxis.getValuePosition(this.xAxis.getRange().getUpper(), false), this.currentPosition.y);
                if (this.cursorLineStyle != CursorLineStyle.FOUR_DIRECTIONS) break;
            }
            case UP_DOWN: {
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y - 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false));
                graphics.drawLine(this.currentPosition.x, this.currentPosition.y + 3, this.currentPosition.x, this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false));
                break;
            }
        }
    }

    public void updateX0Y0Fromdxdy(Dimension size) {
        if (!this.knowX0Y0) {
            this.knowX0Y0 = true;
            int h = size.height;
            int w = size.width;
            if (this.dy != 0.0) {
                this.y0 = this.dy - (double)h / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                    return;
                }
                this.y0 = this.dy + (double)h / 2.0;
                this.x0 = this.dx / this.dy * this.y0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                    return;
                }
            }
            if (this.dx != 0.0) {
                this.x0 = this.dx + (double)w / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                    return;
                }
                this.x0 = this.dx - (double)w / 2.0;
                this.y0 = this.dy / this.dx * this.x0;
                if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                    return;
                }
            }
        } else {
            return;
        }
    }

    private void updatedxdyFromX0Y0() {
        Dimension size = this.infoLabel.getPreferredSize();
        int h = size.height;
        int w = size.width;
        if (this.y0 != 0.0) {
            this.dy = this.y0 + (double)h / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                return;
            }
            this.dy = this.y0 - (double)h / 2.0;
            this.dx = this.x0 * this.dy / this.y0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.x0 - (double)w / 2.0, this.x0 + (double)w / 2.0).inRange(this.dx)) {
                return;
            }
        } else {
            this.dy = 0.0;
        }
        if (this.x0 != 0.0) {
            this.dx = this.x0 - (double)size.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                return;
            }
            this.dx = this.x0 + (double)size.width / 2.0;
            this.dy = this.y0 * this.dx / this.x0;
            if (new Range(0.0, this.x0).inRange(this.dx) && new Range(0.0, this.y0).inRange(this.dy) && new Range(this.y0 - (double)h / 2.0, this.y0 + (double)h / 2.0).inRange(this.dy)) {
                return;
            }
        } else {
            this.dx = 0.0;
        }
    }

    private void updateToDefaultPosition() {
        if (this.trace != null && this.trace.getHotSampleList().size() > 0) {
            this.currentSnappedSample = this.trace.getHotSampleList().get(this.trace.getHotSampleList().size() / 2);
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.currentSnappedSample.getXValue(), false), this.yAxis.getValuePosition(this.currentSnappedSample.getXValue(), false));
            this.xValue = this.currentSnappedSample.getXValue();
            this.yValue = this.currentSnappedSample.getYValue();
        } else {
            this.currentSnappedSample = null;
            this.xValue = this.xAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.xAxis.getRange().getLower()) + Math.log10(this.xAxis.getRange().getUpper())) / 2.0) : (this.xAxis.getRange().getLower() + this.xAxis.getRange().getUpper()) / 2.0;
            this.yValue = this.yAxis.isLogScaleEnabled() ? Math.pow(10.0, (Math.log10(this.yAxis.getRange().getLower()) + Math.log10(this.yAxis.getRange().getUpper())) / 2.0) : (this.yAxis.getRange().getLower() + this.yAxis.getRange().getUpper()) / 2.0;
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        }
        this.updateInfoLableText(true);
    }

    public void setValues(double x, double y) {
        this.xValue = x;
        this.yValue = y;
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLableText(true);
    }

    private void updateInfoLableText(boolean updateX0Y0) {
        String info = "";
        if (this.showName) {
            info = this.name;
        }
        if (this.showSampleInfo && this.currentSnappedSample != null && !this.currentSnappedSample.getInfo().equals("")) {
            info = String.valueOf(info) + "\n" + this.currentSnappedSample.getInfo();
        }
        if (this.showPosition) {
            info = String.valueOf(info) + "\n(" + this.xAxis.format(this.xValue) + ", " + (Double.isNaN(this.yValue) ? "NaN" : this.yAxis.format(this.yValue)) + ")";
        }
        this.infoLabel.setText(info);
        this.knowX0Y0 = !updateX0Y0;
    }

    private void updateInfoLableText() {
        this.updateInfoLableText(true);
    }

    public void setXAxis(Axis axis) {
        if (this.xAxis == axis) {
            return;
        }
        this.xAxis = axis;
        this.updateToDefaultPosition();
        this.repaint();
    }

    public void setYAxis(Axis axis) {
        if (this.yAxis == axis) {
            return;
        }
        this.yAxis = axis;
        this.updateToDefaultPosition();
        this.repaint();
    }

    public void setName(String name) {
        this.name = name;
        this.updateInfoLableText();
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (f != null) {
            this.fontData = this.getFont().getFontData()[0];
        }
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setTrace(Trace trace) {
        if (this.trace == trace) {
            return;
        }
        this.xAxis = trace.getXAxis();
        this.yAxis = trace.getYAxis();
        if (!this.isFree() && this.trace != trace) {
            this.trace.getDataProvider().removeDataProviderListener(this);
        }
        if (this.isFree() || this.trace != trace) {
            this.trace = trace;
            this.updateToDefaultPosition();
        }
        this.trace = trace;
        trace.getDataProvider().addDataProviderListener(this);
        this.repaint();
    }

    public void setFree(Axis xAxis, Axis yAxis) {
        if (this.trace != null) {
            this.trace.getDataProvider().removeDataProviderListener(this);
            this.trace = null;
            this.updateToDefaultPosition();
        }
        this.setXAxis(xAxis);
        this.setYAxis(yAxis);
        this.repaint();
    }

    public boolean isFree() {
        return this.trace == null;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
        this.updateInfoLableText();
    }

    public void setShowSampleInfo(boolean showSampleInfo) {
        this.showSampleInfo = showSampleInfo;
        this.updateInfoLableText();
    }

    public void setShowPosition(boolean showPosition) {
        this.showPosition = showPosition;
        this.updateInfoLableText();
    }

    public void setAnnotationColor(Color annotationColor) {
        this.annotationColor = annotationColor;
        if (annotationColor != null) {
            this.annotationColorRGB = annotationColor.getRGB();
        }
        this.infoLabel.setForegroundColor(annotationColor);
        this.pointer.setForegroundColor(annotationColor);
    }

    public void setAnnotationFont(Font annotationFont) {
        this.infoLabel.setFont(annotationFont);
    }

    public void setCursorLineStyle(CursorLineStyle cursorLineStyle) {
        this.cursorLineStyle = cursorLineStyle;
    }

    public void setCurrentPosition(Point currentPosition, boolean keepLablePosition, boolean calcValueFromPosition) {
        if (keepLablePosition) {
            int deltaX = this.currentPosition.x - currentPosition.x;
            int deltaY = this.currentPosition.y - currentPosition.y;
            this.x0 += (double)deltaX;
            this.y0 += (double)deltaY;
            this.knowX0Y0 = true;
            this.updatedxdyFromX0Y0();
        }
        this.currentPosition = currentPosition;
        if (calcValueFromPosition) {
            this.xValue = this.xAxis.getPositionValue(currentPosition.x, false);
            this.yValue = this.yAxis.getPositionValue(currentPosition.y, false);
        }
        this.updateInfoLableText(keepLablePosition);
        this.repaint();
    }

    public void setCurrentPosition(Point currentPosition, boolean keepLablePosition) {
        this.setCurrentPosition(currentPosition, keepLablePosition, true);
    }

    public void setCurrentSnappedSample(ISample currentSnappedSample, boolean keepLabelPosition) {
        if (!this.trace.getHotSampleList().contains(currentSnappedSample)) {
            this.updateToDefaultPosition();
        } else {
            this.currentSnappedSample = currentSnappedSample;
            Point newPosition = new Point(this.xAxis.getValuePosition(currentSnappedSample.getXValue(), false), this.yAxis.getValuePosition(currentSnappedSample.getYValue(), false));
            this.xValue = currentSnappedSample.getXValue();
            this.yValue = currentSnappedSample.getYValue();
            if (Double.isNaN(currentSnappedSample.getXPlusError())) {
                this.yValue = Double.NaN;
            }
            this.setCurrentPosition(newPosition, keepLabelPosition, false);
        }
        this.repaint();
    }

    @Override
    public void axisRevalidated(Axis axis) {
        this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        this.updateInfoLableText();
    }

    @Override
    public void axisRangeChanged(Axis axis, Range old_range, Range new_range) {
    }

    @Override
    public void dataChanged(IDataProvider dataProvider) {
        if (this.trace == null) {
            return;
        }
        if (this.trace.getHotSampleList().contains(this.currentSnappedSample)) {
            if (this.yValue != this.currentSnappedSample.getYValue()) {
                this.yValue = this.currentSnappedSample.getYValue();
            }
            if (this.xValue != this.currentSnappedSample.getXValue()) {
                this.xValue = this.currentSnappedSample.getXValue();
            }
            this.currentPosition = new Point(this.xAxis.getValuePosition(this.xValue, false), this.yAxis.getValuePosition(this.yValue, false));
        } else if (this.trace.getHotSampleList().size() > 0) {
            this.updateToDefaultPosition();
            this.pointerDragged = false;
        }
    }

    public void setxyGraph(XYGraph xyGraph) {
        this.xyGraph = xyGraph;
    }

    public void setdxdy(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
        this.knowX0Y0 = false;
        this.repaint();
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public String getName() {
        return this.name;
    }

    public double getXValue() {
        return this.xValue;
    }

    public double getYValue() {
        return this.yValue;
    }

    public CursorLineStyle getCursorLineStyle() {
        return this.cursorLineStyle;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSampleInfo() {
        return this.showSampleInfo;
    }

    public boolean isShowPosition() {
        return this.showPosition;
    }

    public Color getAnnotationColor() {
        return this.annotationColor;
    }

    @Override
    public void axisForegroundColorChanged(Axis axis, Color oldColor, Color newColor) {
    }

    @Override
    public void axisTitleChanged(Axis axis, String oldTitle, String newTitle) {
    }

    @Override
    public void axisAutoScaleChanged(Axis axis, boolean oldAutoScale, boolean newAutoScale) {
    }

    @Override
    public void axisLogScaleChanged(Axis axis, boolean old, boolean logScale) {
    }

    public RGB getAnnotationColorRGB() {
        return this.annotationColorRGB;
    }

    public static enum CursorLineStyle {
        NONE(0, "None"),
        UP_DOWN(1, "Up&Down"),
        LEFT_RIGHT(2, "Left&Right"),
        FOUR_DIRECTIONS(3, "Four Directions");

        private int index;
        private String description;

        private CursorLineStyle(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[CursorLineStyle.values().length];
            int i = 0;
            CursorLineStyle[] cursorLineStyleArray = CursorLineStyle.values();
            int n = cursorLineStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                CursorLineStyle p = cursorLineStyleArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class InfoLabelDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MovingAnnotationLabelCommand command;

        InfoLabelDragger() {
        }

        public void mouseDragged(MouseEvent me) {
            Annotation.this.x0 = me.getLocation().x - Annotation.this.currentPosition.x;
            Annotation.this.y0 = me.getLocation().y - Annotation.this.currentPosition.y;
            Annotation.this.knowX0Y0 = true;
            Annotation.this.updatedxdyFromX0Y0();
            Annotation.this.repaint();
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.command = new MovingAnnotationLabelCommand(Annotation.this);
            this.command.setBeforeMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.infoLabelArmed = true;
            Annotation.this.repaint();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            this.command.setAfterMovingDxDy(Annotation.this.dx, Annotation.this.dy);
            Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
            Annotation.this.infoLabelArmed = false;
            Annotation.this.repaint();
            me.consume();
        }
    }

    class Pointer
    extends Figure {
        public Pointer() {
            this.setCursor(Cursors.CROSS);
            PointerDragger dragger = new PointerDragger();
            this.addMouseMotionListener((MouseMotionListener)dragger);
            this.addMouseListener(dragger);
        }

        protected void paintClientArea(Graphics graphics) {
            super.paintClientArea(graphics);
            if (Preferences.useAdvancedGraphics()) {
                graphics.setAntialias(1);
            }
            Rectangle clientArea = this.getClientArea().getCopy().shrink(3, 3);
            graphics.drawLine(clientArea.x, clientArea.y, clientArea.x + clientArea.width, clientArea.y + clientArea.height);
            graphics.drawLine(clientArea.x + clientArea.width, clientArea.y, clientArea.x, clientArea.y + clientArea.height);
        }

        class PointerDragger
        extends MouseMotionListener.Stub
        implements MouseListener {
            private MovingAnnotationCommand command;

            PointerDragger() {
            }

            public void mouseDragged(MouseEvent me) {
                if (((Pointer)Pointer.this).Annotation.this.trace == null) {
                    Annotation.this.setCurrentPosition(me.getLocation(), me.getState() == 786432);
                } else {
                    ISample tempSample = null;
                    double minD = Double.POSITIVE_INFINITY;
                    for (ISample s : ((Pointer)Pointer.this).Annotation.this.trace.getHotSampleList()) {
                        double d = Math.sqrt(Math.pow(((Pointer)Pointer.this).Annotation.this.xAxis.getValuePosition(s.getXValue(), false) - me.getLocation().x, 2.0) + Math.pow(((Pointer)Pointer.this).Annotation.this.yAxis.getValuePosition(s.getYValue(), false) - me.getLocation().y, 2.0));
                        if (!(minD > d)) continue;
                        minD = d;
                        tempSample = s;
                    }
                    if (tempSample != null && ((Pointer)Pointer.this).Annotation.this.currentSnappedSample != tempSample) {
                        Annotation.this.setCurrentSnappedSample(tempSample, me.getState() == 786432);
                    } else if (tempSample == null) {
                        Annotation.this.setCurrentPosition(me.getLocation(), me.getState() == 786432);
                        ((Pointer)Pointer.this).Annotation.this.pointerDragged = true;
                    }
                }
                me.consume();
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                this.command = new MovingAnnotationCommand(Annotation.this);
                if (Annotation.this.isFree()) {
                    this.command.setBeforeMovePosition(((Pointer)Pointer.this).Annotation.this.currentPosition);
                } else {
                    this.command.setBeforeMoveSnappedSample(((Pointer)Pointer.this).Annotation.this.currentSnappedSample);
                }
                this.command.setBeforeDxDy(((Pointer)Pointer.this).Annotation.this.dx, ((Pointer)Pointer.this).Annotation.this.dy);
                me.consume();
            }

            public void mouseReleased(MouseEvent me) {
                if (this.command != null) {
                    if (Annotation.this.isFree()) {
                        this.command.setAfterMovePosition(((Pointer)Pointer.this).Annotation.this.currentPosition);
                    } else {
                        this.command.setAfterMoveSnappedSample(((Pointer)Pointer.this).Annotation.this.currentSnappedSample);
                    }
                    this.command.setAfterDxDy(((Pointer)Pointer.this).Annotation.this.dx, ((Pointer)Pointer.this).Annotation.this.dy);
                    ((Pointer)Pointer.this).Annotation.this.xyGraph.getOperationsManager().addCommand(this.command);
                }
            }
        }
    }
}

