/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.csstudio.swt.xygraph.Preferences;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class Legend
extends RectangleFigure {
    private static final int ICON_WIDTH = 15;
    private static final int INNER_GAP = 2;
    private static final int OUT_GAP = 5;
    private final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
    private final List<Trace> traceList = new ArrayList<Trace>();
    private final List<LegendPosition> positionList = new ArrayList<LegendPosition>();

    public Legend(XYGraph xyGraph) {
        xyGraph.getPlotArea().addPropertyChangeListener("background_color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Legend.this.setBackgroundColor((Color)evt.getNewValue());
            }
        });
        this.setBackgroundColor(xyGraph.getPlotArea().getBackgroundColor());
        this.setForegroundColor(this.BLACK_COLOR);
        this.setOpaque(false);
        this.setOutline(false);
        this.addListenerToBoldline();
    }

    public void addTrace(Trace trace) {
        this.traceList.add(trace);
    }

    public boolean removeTrace(Trace trace) {
        return this.traceList.remove(trace);
    }

    protected void outlineShape(Graphics graphics) {
        graphics.setForegroundColor(this.traceList.get(0).getYAxis().getForegroundColor());
        super.outlineShape(graphics);
    }

    protected void fillShape(Graphics graphics) {
        if (!((XYGraph)this.getParent()).isTransparent()) {
            super.fillShape(graphics);
        }
        int hPos = this.bounds.x + 2;
        int vPos = this.bounds.y - 2;
        int i = 0;
        this.positionList.clear();
        for (Trace trace : this.traceList) {
            int hwidth = 22 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
            int hEnd = hPos + hwidth;
            if (hEnd > this.bounds.x + this.bounds.width && i > 0) {
                hPos = this.bounds.x + 2;
                vPos += 17;
                hEnd = hPos + hwidth;
            }
            this.drawTraceLagend(trace, graphics, hPos, vPos);
            hPos = hEnd;
            ++i;
        }
    }

    private void drawTraceLagend(Trace trace, Graphics graphics, int hPos, int vPos) {
        graphics.pushState();
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        graphics.setForegroundColor(trace.getTraceColor());
        graphics.setBackgroundColor(trace.getTraceColor());
        int rectangleX = hPos + 4;
        int rectangleY = vPos + 2;
        graphics.fillRectangle(rectangleX, rectangleY, 10, 10);
        int textX = hPos + 15 + 2;
        int textY = vPos + 7 - FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).height / 2;
        graphics.drawText(trace.getName(), textX, textY);
        int x2 = textX + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
        int y2 = textY + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).height;
        this.positionList.add(new LegendPosition(rectangleX, rectangleY, x2, y2));
        graphics.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int maxWidth = 0;
        int hEnd = 2;
        int height = 17;
        for (Trace trace : this.traceList) {
            if ((hEnd = hEnd + 5 + 15 + 2 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width) > wHint) {
                hEnd = 24 + FigureUtilities.getTextExtents((String)trace.getName(), (Font)this.getFont()).width;
                height += 17;
            }
            if (maxWidth >= hEnd) continue;
            maxWidth = hEnd;
        }
        return new Dimension(maxWidth, height);
    }

    public List<Trace> getTraceList() {
        return this.traceList;
    }

    private void addListenerToBoldline() {
        this.addMouseListener((MouseListener)new MouseListener.Stub(){
            Trace holdingTrace;
            int originalWidth;

            public void mousePressed(MouseEvent me) {
                this.mouseReleased(me);
                int i = 0;
                while (i < Legend.this.positionList.size()) {
                    LegendPosition pos = Legend.this.positionList.get(i);
                    if (pos.isContained(me.x, me.y)) {
                        this.holdingTrace = Legend.this.traceList.get(i);
                        if (this.holdingTrace.getTraceType() == Trace.TraceType.SOLID_LINE) {
                            this.originalWidth = this.holdingTrace.getLineWidth();
                            this.holdingTrace.setLineWidth(this.originalWidth * 2);
                            break;
                        }
                        this.holdingTrace = null;
                        break;
                    }
                    ++i;
                }
            }

            public void mouseReleased(MouseEvent me) {
                if (this.holdingTrace != null) {
                    if (this.originalWidth > 0) {
                        this.holdingTrace.setLineWidth(this.originalWidth);
                    } else {
                        this.holdingTrace.setLineWidth(1);
                    }
                    this.originalWidth = 0;
                    this.holdingTrace = null;
                }
            }
        });
    }

    static class LegendPosition {
        int x1;
        int x2;
        int y1;
        int y2;

        public LegendPosition(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public boolean isContained(int x, int y) {
            boolean result = false;
            if (this.x1 <= x && x <= this.x2 && this.y1 <= y && y <= this.y2) {
                result = true;
            }
            return result;
        }
    }
}

