/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.figures;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.XYGraphToolbar;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ToolbarArmedXYGraph
extends Figure {
    private final XYGraph xyGraph;
    private final XYGraphToolbar toolbar;
    private boolean transparent;
    private static final int MARGIN = 3;

    public ToolbarArmedXYGraph() {
        this(new XYGraph());
    }

    public ToolbarArmedXYGraph(XYGraph xyGraph) {
        this(xyGraph, 1);
    }

    public ToolbarArmedXYGraph(XYGraph xyGraph, int flags) {
        this.xyGraph = xyGraph;
        this.toolbar = new XYGraphToolbar(this.xyGraph, flags);
        xyGraph.setOpaque(false);
        this.toolbar.setOpaque(false);
        this.add((IFigure)this.toolbar);
        this.add((IFigure)xyGraph);
    }

    protected void layout() {
        Rectangle clientArea = this.getClientArea().getCopy();
        if (this.toolbar.isVisible()) {
            this.toolbar.invalidate();
            Dimension size = this.toolbar.getPreferredSize(clientArea.width - 3, -1);
            this.toolbar.setBounds(new Rectangle(clientArea.x + 3, clientArea.y + 3, size.width, size.height));
            clientArea.y += size.height + 6;
            clientArea.height -= size.height + 6;
        }
        this.xyGraph.setBounds(new Rectangle(clientArea));
        super.layout();
    }

    public void setShowToolbar(boolean showToolbar) {
        this.toolbar.setVisible(showToolbar);
        this.revalidate();
    }

    public boolean isShowToolbar() {
        return this.toolbar.isVisible();
    }

    public XYGraph getXYGraph() {
        return this.xyGraph;
    }

    public boolean isOpaque() {
        return false;
    }

    public void paintFigure(Graphics graphics) {
        if (!this.transparent) {
            graphics.fillRectangle(this.getClientArea());
        }
        super.paintFigure(graphics);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.xyGraph.setTransparent(transparent);
    }

    public void addToolbarButton(Clickable button) {
        this.toolbar.addButton(button);
    }
}

