/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.Figure;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;

public abstract class AbstractScale
extends Figure {
    public static final double DEFAULT_MAX = 100.0;
    public static final double DEFAULT_MIN = 0.0;
    public static final String DEFAULT_ENGINEERING_FORMAT = "0.####E0";
    private static final int ENGINEERING_LIMIT = 4;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd\nHH:mm:ss";
    private LabelSide tickLableSide = LabelSide.Primary;
    public static final double DEFAULT_LOG_SCALE_MIN = 0.1;
    public static final double DEFAULT_LOG_SCALE_MAX = 100.0;
    private String default_decimal_format = "############.##";
    protected boolean logScaleEnabled = false;
    protected double min = 0.0;
    protected double max = 100.0;
    private String formatPattern;
    private int timeUnit = 0;
    protected boolean dirty = true;
    private boolean dateEnabled = false;
    private boolean scaleLineVisible = true;
    private int majorTickMarkStepHint = 30;
    private int minorTickMarkStepHint = 4;
    private boolean minorTicksVisible = true;
    private double majorGridStep = 0.0;
    private boolean autoFormat = true;
    private Range range = new Range(this.min, this.max);
    private boolean decreaseValue = true;

    public String format(Object obj) {
        return this.format(obj, false);
    }

    public String format(Object obj, boolean minOrMaxDate) {
        if (this.isDateEnabled()) {
            if (this.autoFormat || this.formatPattern == null || this.formatPattern.equals("") || this.formatPattern.equals(this.default_decimal_format) || this.formatPattern.equals(DEFAULT_ENGINEERING_FORMAT)) {
                this.formatPattern = DEFAULT_DATE_FORMAT;
                double length = Math.abs(this.max - this.min);
                this.formatPattern = length <= 5000.0 || this.timeUnit == 14 ? "ss.SSS" : (length <= 1800000.0 || this.timeUnit == 13 ? "HH:mm:ss" : (length <= 8.64E7 || this.timeUnit == 12 ? "HH:mm" : (length <= 6.048E8 || this.timeUnit == 11 ? "MM-dd\nHH:mm" : (length <= 2.592E9 || this.timeUnit == 5 ? "MM-dd" : "yyyy-MM-dd"))));
                this.autoFormat = true;
            }
            if (minOrMaxDate && this.autoFormat) {
                if (Math.abs(this.max - this.min) < 5000.0) {
                    return new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss.SSS").format(obj);
                }
                return new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(obj);
            }
            return new SimpleDateFormat(this.formatPattern).format(obj);
        }
        if (this.formatPattern == null || this.formatPattern.equals("")) {
            this.formatPattern = this.default_decimal_format;
            this.autoFormat = true;
        }
        String value = new DecimalFormat(this.formatPattern).format(obj);
        if (this.decreaseValue) {
            return this.formatDecreasedValue(value);
        }
        return value;
    }

    public void setDecreaseValue(boolean decrease) {
        this.decreaseValue = decrease;
    }

    public String formatDecreasedValue(String value) {
        int index = -1;
        index = value.lastIndexOf(",000,000,000,000");
        if (index != -1) {
            return String.valueOf(value.substring(0, index)) + "T";
        }
        index = value.lastIndexOf(",000,000,000");
        if (index != -1) {
            return String.valueOf(value.substring(0, index)) + "G";
        }
        index = value.lastIndexOf(",000,000");
        if (index != -1) {
            return String.valueOf(value.substring(0, index)) + "M";
        }
        index = value.lastIndexOf(",000");
        if (index != -1) {
            return String.valueOf(value.substring(0, index)) + "K";
        }
        return value;
    }

    public int getMajorTickMarkStepHint() {
        return this.majorTickMarkStepHint;
    }

    public Range getRange() {
        return this.range;
    }

    public LabelSide getTickLablesSide() {
        return this.tickLableSide;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public boolean isDateEnabled() {
        return this.dateEnabled;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    public boolean isMinorTicksVisible() {
        return this.minorTicksVisible;
    }

    public boolean isScaleLineVisible() {
        return this.scaleLineVisible;
    }

    public void setDateEnabled(boolean dateEnabled) {
        this.dateEnabled = dateEnabled;
        this.setDirty(true);
        this.revalidate();
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setFormatPattern(String formatPattern) {
        try {
            new DecimalFormat(formatPattern);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        this.formatPattern = formatPattern;
        this.autoFormat = false;
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.setDirty(true);
        this.revalidate();
    }

    public void setLogScale(boolean enabled) throws IllegalStateException {
        if (this.logScaleEnabled == enabled) {
            return;
        }
        if (enabled) {
            if (this.min == 0.0 && this.max == 100.0) {
                this.min = 0.1;
                this.max = 100.0;
            }
            if (this.min <= 0.0) {
                this.min = 0.1;
            }
            if (this.max <= this.min) {
                this.max = this.min + 100.0;
            }
        } else if (this.min == 0.1 && this.max == 100.0) {
            this.min = 0.0;
            this.max = 100.0;
        }
        this.logScaleEnabled = enabled;
        this.range = new Range(this.min, this.max);
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setMajorTickMarkStepHint(int majorTickMarkStepHint) {
        this.majorTickMarkStepHint = majorTickMarkStepHint;
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setMinorTicksVisible(boolean minorTicksVisible) {
        this.minorTicksVisible = minorTicksVisible;
    }

    public void setRange(Range range) {
        if (range == null) {
            SWT.error((int)4);
            return;
        }
        this.setRange(range.getLower(), range.getUpper());
    }

    public void setRange(double t1, double t2, boolean honorOriginDirection) {
        if (honorOriginDirection) {
            if (this.getRange().isMinBigger()) {
                this.setRange(t1 > t2 ? t1 : t2, t1 > t2 ? t2 : t1);
            } else {
                this.setRange(t1 > t2 ? t2 : t1, t1 > t2 ? t1 : t2);
            }
        } else {
            this.setRange(t1, t2);
        }
    }

    public void setRange(double lower, double upper) {
        if (Double.isNaN(lower) || Double.isNaN(upper) || Double.isInfinite(lower) || Double.isInfinite(upper) || Double.isInfinite(upper - lower)) {
            throw new IllegalArgumentException("Illegal range: lower=" + lower + ", upper=" + upper);
        }
        if (lower == upper && Double.isInfinite(upper = lower + 1.0)) {
            throw new IllegalArgumentException("Illegal range: lower=" + lower + ", upper=" + upper);
        }
        if (this.logScaleEnabled && lower <= 0.0) {
            lower = 0.1;
        }
        this.min = lower;
        this.max = upper;
        if (this.formatPattern == null || this.formatPattern == this.default_decimal_format) {
            if (Math.abs(this.max - this.min) > 0.1) {
                this.default_decimal_format = "############.##";
            } else {
                this.default_decimal_format = "##.##";
                double mantissa = Math.abs(this.max - this.min);
                while (mantissa < 1.0) {
                    mantissa *= 10.0;
                    this.default_decimal_format = String.valueOf(this.default_decimal_format) + "#";
                }
            }
            this.formatPattern = this.default_decimal_format;
            this.autoFormat = true;
        }
        if (this.formatPattern.equals(this.default_decimal_format) || this.formatPattern.equals(DEFAULT_ENGINEERING_FORMAT)) {
            this.formatPattern = this.max != 0.0 && Math.abs(Math.log10(Math.abs(this.max))) >= 4.0 || this.min != 0.0 && Math.abs(Math.log10(Math.abs(this.min))) >= 4.0 ? DEFAULT_ENGINEERING_FORMAT : this.default_decimal_format;
            this.autoFormat = true;
        }
        this.range = new Range(this.min, this.max);
        this.setDirty(true);
        this.revalidate();
        this.repaint();
    }

    public void setScaleLineVisible(boolean scaleLineVisible) {
        this.scaleLineVisible = scaleLineVisible;
    }

    public void setTickLableSide(LabelSide tickLabelSide) {
        this.tickLableSide = tickLabelSide;
        this.revalidate();
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
        this.setDirty(true);
    }

    public abstract void updateTick();

    public void setMajorGridStep(double majorGridStep) {
        this.majorGridStep = majorGridStep;
        this.setDirty(true);
    }

    public double getMajorGridStep() {
        return this.majorGridStep;
    }

    public void setMinorTickMarkStepHint(int minorTickMarkStepHint) {
        this.minorTickMarkStepHint = minorTickMarkStepHint;
    }

    public int getMinorTickMarkStepHint() {
        return this.minorTickMarkStepHint;
    }

    public void setAutoFormat(boolean autoFormat) {
        this.autoFormat = autoFormat;
        if (autoFormat) {
            this.formatPattern = null;
            this.setRange(this.getRange());
            this.format(0);
        }
    }

    public boolean isAutoFormat() {
        return this.autoFormat;
    }

    public static enum LabelSide {
        Primary,
        Secondary;

    }
}

