/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.csstudio.swt.xygraph.linearscale.LinearScale;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;

public class LinearScaleTickLabels
extends Figure {
    private static final int TICK_LABEL_GAP = 20;
    private ArrayList<Double> tickLabelValues;
    private ArrayList<String> tickLabels;
    private ArrayList<Integer> tickLabelPositions;
    private ArrayList<Boolean> tickVisibilities;
    private int tickLabelMaxLength;
    private int tickLabelMaxHeight;
    private int gridStepInPixel;
    private LinearScale scale;

    protected LinearScaleTickLabels(LinearScale linearScale) {
        this.scale = linearScale;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickVisibilities = new ArrayList();
        this.setFont(this.scale.getFont());
        this.setForegroundColor(this.scale.getForegroundColor());
    }

    protected void update(int length) {
        this.tickLabelValues.clear();
        this.tickLabels.clear();
        this.tickLabelPositions.clear();
        if (this.scale.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(length);
        } else {
            this.updateTickLabelForLinearScale(length);
        }
        this.updateTickVisibility();
        this.updateTickLabelMaxLengthAndHeight();
    }

    private void updateTickLabelForLogScale(int length) {
        BigDecimal tickStep;
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("the range for log scale must be in positive range");
        }
        boolean minBigger = max < min;
        int digitMin = (int)Math.ceil(Math.log10(min));
        int digitMax = (int)Math.ceil(Math.log10(max));
        BigDecimal MIN = new BigDecimal(new Double(min).toString());
        BigDecimal firstPosition = MIN.remainder(tickStep = this.pow(10.0, digitMin - 1)).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : (minBigger ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep));
        boolean minDateAdded = false;
        if (MIN.compareTo(firstPosition) == (minBigger ? 1 : -1)) {
            this.tickLabelValues.add(min);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)MIN.doubleValue());
                this.tickLabels.add(this.scale.format(date, true));
                minDateAdded = true;
            } else {
                this.tickLabels.add(this.scale.format(MIN.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getMargin());
        }
        int i = digitMin;
        while (!(minBigger ? i < digitMax : i > digitMax)) {
            int tickLabelPosition;
            if (Math.abs(digitMax - digitMin) > 20) {
                BigDecimal v = this.pow(10.0, i);
                if (v.doubleValue() > max) break;
                if (this.scale.isDateEnabled()) {
                    Date date = new Date((long)v.doubleValue());
                    this.tickLabels.add(this.scale.format(date, i == digitMin && !minDateAdded));
                } else {
                    this.tickLabels.add(this.scale.format(v.doubleValue()));
                }
                this.tickLabelValues.add(v.doubleValue());
                tickLabelPosition = (int)((Math.log10(v.doubleValue()) - Math.log10(min)) / (Math.log10(max) - Math.log10(min)) * (double)length) + this.scale.getMargin();
                this.tickLabelPositions.add(tickLabelPosition);
            } else {
                BigDecimal j = firstPosition;
                while (!(minBigger ? !(j.doubleValue() >= this.pow(10.0, i - 1).doubleValue()) : !(j.doubleValue() <= this.pow(10.0, i).doubleValue()))) {
                    if (!minBigger ? j.doubleValue() > max : j.doubleValue() < max) break;
                    if (this.scale.isDateEnabled()) {
                        Date date = new Date((long)j.doubleValue());
                        this.tickLabels.add(this.scale.format(date, j == firstPosition && !minDateAdded));
                    } else {
                        this.tickLabels.add(this.scale.format(j.doubleValue()));
                    }
                    this.tickLabelValues.add(j.doubleValue());
                    tickLabelPosition = (int)((Math.log10(j.doubleValue()) - Math.log10(min)) / (Math.log10(max) - Math.log10(min)) * (double)length) + this.scale.getMargin();
                    this.tickLabelPositions.add(tickLabelPosition);
                    BigDecimal bigDecimal = j = minBigger ? j.subtract(tickStep) : j.add(tickStep);
                }
                tickStep = minBigger ? tickStep.divide(this.pow(10.0, 1)) : tickStep.multiply(this.pow(10.0, 1));
                firstPosition = minBigger ? this.pow(10.0, i - 1) : tickStep.add(this.pow(10.0, i));
            }
            i += minBigger ? -1 : 1;
        }
        if (minBigger ? max < this.tickLabelValues.get(this.tickLabelValues.size() - 1) : max > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.tickLabelValues.add(max);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)max);
                this.tickLabels.add(this.scale.format(date, true));
            } else {
                this.tickLabels.add(this.scale.format(max));
            }
            this.tickLabelPositions.add(this.scale.getMargin() + length);
        }
    }

    private void updateTickLabelForLinearScale(int length) {
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        BigDecimal gridStepBigDecimal = this.getGridStep(length, min, max);
        this.gridStepInPixel = (int)((double)length * gridStepBigDecimal.doubleValue() / (max - min));
        this.updateTickLabelForLinearScale(length, gridStepBigDecimal);
    }

    private void updateTickLabelForLinearScale(int length, BigDecimal tickStep) {
        Date date;
        BigDecimal zeroOclock;
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        boolean minBigger = max < min;
        BigDecimal MIN = new BigDecimal(new Double(min).toString());
        BigDecimal firstPosition = MIN.remainder(tickStep).doubleValue() <= 0.0 ? MIN.subtract(MIN.remainder(tickStep)) : MIN.subtract(MIN.remainder(tickStep)).add(tickStep);
        if (this.scale.isDateEnabled() && MIN.compareTo(zeroOclock = firstPosition.subtract(new BigDecimal(new Double(3600000.0).toString()))) == -1) {
            firstPosition = zeroOclock;
        }
        int r = minBigger ? 1 : -1;
        boolean minDateAdded = false;
        if (MIN.compareTo(firstPosition) == r) {
            this.tickLabelValues.add(min);
            if (this.scale.isDateEnabled()) {
                date = new Date((long)MIN.doubleValue());
                this.tickLabels.add(this.scale.format(date, true));
                minDateAdded = true;
            } else {
                this.tickLabels.add(this.scale.format(MIN.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getMargin());
        }
        BigDecimal b = firstPosition;
        while (!(max >= min ? !(b.doubleValue() < max) : !(b.doubleValue() > max))) {
            if (this.scale.isDateEnabled()) {
                Date date2 = new Date((long)b.doubleValue());
                this.tickLabels.add(this.scale.format(date2, b == firstPosition && !minDateAdded));
            } else {
                this.tickLabels.add(this.scale.format(b.doubleValue()));
            }
            this.tickLabelValues.add(b.doubleValue());
            int tickLabelPosition = (int)((b.doubleValue() - min) / (max - min) * (double)length) + this.scale.getMargin();
            this.tickLabelPositions.add(tickLabelPosition);
            b = b.add(tickStep);
        }
        this.tickLabelValues.add(max);
        if (this.scale.isDateEnabled()) {
            date = new Date((long)max);
            this.tickLabels.add(this.scale.format(date, true));
        } else {
            this.tickLabels.add(this.scale.format(max));
        }
        this.tickLabelPositions.add(this.scale.getMargin() + length);
    }

    private void updateTickVisibility() {
        this.tickVisibilities.clear();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickVisibilities.add(Boolean.TRUE);
            ++i;
        }
        if (this.tickLabelPositions.size() == 0) {
            return;
        }
        int previousPosition = 0;
        String previousLabel = null;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            String currentLabel;
            boolean hasSpaceToDraw = true;
            if (i2 != 0) {
                hasSpaceToDraw = this.hasSpaceToDraw(previousPosition, this.tickLabelPositions.get(i2), previousLabel, this.tickLabels.get(i2));
            }
            boolean isRepeatSameTickAndNotEnd = (currentLabel = this.tickLabels.get(i2)).equals(previousLabel) && i2 != 0 && i2 != this.tickLabelPositions.size() - 1;
            boolean isMajorTickOrEnd = true;
            if (this.scale.isLogScaleEnabled()) {
                boolean bl = isMajorTickOrEnd = this.isMajorTick(this.tickLabelValues.get(i2)) || i2 == 0 || i2 == this.tickLabelPositions.size() - 1;
            }
            if (!hasSpaceToDraw || isRepeatSameTickAndNotEnd || !isMajorTickOrEnd) {
                this.tickVisibilities.set(i2, Boolean.FALSE);
            } else {
                previousPosition = this.tickLabelPositions.get(i2);
                previousLabel = currentLabel;
            }
            ++i2;
        }
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.scale.isLogScaleEnabled()) {
            return true;
        }
        return Math.log10(tickValue) % 1.0 == 0.0;
    }

    private boolean hasSpaceToDraw(int previousPosition, int tickLabelPosition, String previousTickLabel, String tickLabel) {
        Dimension tickLabelSize = FigureUtilities.getTextExtents((String)tickLabel, (Font)this.scale.getFont());
        Dimension previousTickLabelSize = FigureUtilities.getTextExtents((String)previousTickLabel, (Font)this.scale.getFont());
        int interval = tickLabelPosition - previousPosition;
        int textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)previousTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
        boolean noLapOnPrevoius = true;
        boolean noLapOnEnd = true;
        if (tickLabelPosition != this.tickLabelPositions.get(this.tickLabelPositions.size() - 1)) {
            noLapOnPrevoius = interval > textLength + 20;
            Dimension endTickLabelSize = FigureUtilities.getTextExtents((String)this.tickLabels.get(this.tickLabels.size() - 1), (Font)this.scale.getFont());
            interval = this.tickLabelPositions.get(this.tickLabelPositions.size() - 1) - tickLabelPosition;
            textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)endTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
            boolean bl = noLapOnEnd = interval > textLength + 20;
        }
        return noLapOnPrevoius && noLapOnEnd;
    }

    private void updateTickLabelMaxLengthAndHeight() {
        int maxLength = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickVisibilities.size() > i && this.tickVisibilities.get(i).booleanValue()) {
                Dimension p = FigureUtilities.getTextExtents((String)this.tickLabels.get(i), (Font)this.scale.getFont());
                if (this.tickLabels.get(0).startsWith("-") && !this.tickLabels.get(i).startsWith("-")) {
                    p.width += FigureUtilities.getTextExtents((String)"-", (Font)this.getFont()).width;
                }
                if (p.width > maxLength) {
                    maxLength = p.width;
                }
                if (p.height > maxHeight) {
                    maxHeight = p.height;
                }
            }
            ++i;
        }
        this.tickLabelMaxLength = maxLength;
        this.tickLabelMaxHeight = maxHeight;
    }

    private BigDecimal pow(double base, int expornent) {
        BigDecimal value = expornent > 0 ? new BigDecimal(new Double(base).toString()).pow(expornent) : BigDecimal.ONE.divide(new BigDecimal(new Double(base).toString()).pow(-expornent));
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private BigDecimal getGridStep(int lengthInPixels, double min, double max) {
        block25: {
            if ((int)this.scale.getMajorGridStep() != 0) {
                return new BigDecimal(this.scale.getMajorGridStep());
            }
            if (lengthInPixels <= 0) {
                lengthInPixels = 1;
            }
            minBigger = false;
            if (min >= max) {
                if (max == min) {
                    max += 1.0;
                } else {
                    minBigger = true;
                    swap = min;
                    min = max;
                    max = swap;
                }
            }
            length = Math.abs(max - min);
            majorTickMarkStepHint = this.scale.getMajorTickMarkStepHint();
            if (majorTickMarkStepHint > (double)lengthInPixels) {
                majorTickMarkStepHint = lengthInPixels;
            }
            gridStepHint = length / (double)lengthInPixels * majorTickMarkStepHint;
            if (this.scale.isDateEnabled()) {
                timeStep = max - min < 10000.0 ? 1L : (max - min < 60000.0 ? 1000L : (max - min < 600000.0 ? 10000L : (max - min < 6400000.0 ? 60000L : (max - min < 4.32E7 ? 600000L : (max - min < 8.64E7 ? 1800000L : (max - min < 6.048E8 ? 3600000L : 86400000L))))));
                if (this.scale.getTimeUnit() == 13) {
                    timeStep = 1000L;
                } else if (this.scale.getTimeUnit() == 12) {
                    timeStep = 60000L;
                } else if (this.scale.getTimeUnit() == 11) {
                    timeStep = 3600000L;
                } else if (this.scale.getTimeUnit() == 5) {
                    timeStep = 86400000L;
                } else if (this.scale.getTimeUnit() == 2) {
                    timeStep = 2592000000L;
                } else if (this.scale.getTimeUnit() == 1) {
                    timeStep = 31536000000L;
                }
                temp = gridStepHint + ((double)timeStep - gridStepHint % (double)timeStep);
                if (minBigger) {
                    temp = -temp;
                }
                return new BigDecimal(temp);
            }
            mantissa = gridStepHint;
            exponent = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl53
            if (mantissa == 0.0) break block25;
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exponent;
            }
            break block25;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exponent;
lbl53:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? BigDecimal.TEN.multiply(this.pow(10.0, exponent)) : (mantissa > 3.5 ? new BigDecimal(new Double(5.0).toString()).multiply(this.pow(10.0, exponent)) : (mantissa > 1.5 ? new BigDecimal(new Double(2.0).toString()).multiply(this.pow(10.0, exponent)) : this.pow(10.0, exponent)));
        if (minBigger) {
            gridStep = gridStep.negate();
        }
        return gridStep;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        if (this.scale.isHorizontal()) {
            this.drawXTick(graphics);
        } else {
            this.drawYTick(graphics);
        }
        super.paintClientArea(graphics);
    }

    private void drawXTick(Graphics grahics) {
        grahics.setFont(this.scale.getFont());
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int fontWidth = FigureUtilities.getTextExtents((String)text, (Font)this.getFont()).width;
                int x = (int)Math.ceil((double)this.tickLabelPositions.get(i).intValue() - (double)fontWidth / 2.0);
                grahics.drawText(text, x, 0);
            }
            ++i;
        }
    }

    private void drawYTick(Graphics grahpics) {
        grahpics.setFont(this.scale.getFont());
        int fontHeight = this.tickLabelMaxHeight;
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickVisibilities.size() == 0 || this.tickLabels.size() == 0) break;
            if (this.tickVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                int x = 0;
                if (this.tickLabels.get(0).startsWith("-") && !text.startsWith("-")) {
                    x += FigureUtilities.getTextExtents((String)"-", (Font)this.getFont()).width;
                }
                int y = (int)Math.ceil((double)(this.scale.getLength() - this.tickLabelPositions.get(i)) - (double)fontHeight / 2.0);
                grahpics.drawText(text, x, y);
            }
            ++i;
        }
    }

    public int getTickLabelMaxLength() {
        return this.tickLabelMaxLength;
    }

    public int getTickLabelMaxHeight() {
        return this.tickLabelMaxHeight;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        return this.tickVisibilities;
    }

    public int getGridStepInPixel() {
        return this.gridStepInPixel;
    }
}

