/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.linearscale;

public class Range {
    private final double lower;
    private final double upper;

    public Range(double start, double end) {
        this.lower = start;
        this.upper = end;
    }

    public boolean inRange(double value, boolean includeBoundary) {
        if (this.lower <= this.upper) {
            if (includeBoundary) {
                return value >= this.lower && value <= this.upper;
            }
            return value > this.lower && value < this.upper;
        }
        if (includeBoundary) {
            return value >= this.upper && value <= this.lower;
        }
        return value > this.upper && value < this.lower;
    }

    public boolean inRange(double value) {
        if (this.lower <= this.upper) {
            return value >= this.lower && value <= this.upper;
        }
        return value >= this.upper && value <= this.lower;
    }

    public boolean isMinBigger() {
        return this.lower > this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return other.lower == this.lower && other.upper == this.upper;
    }

    public int hashCode() {
        int result = (int)Double.doubleToLongBits(this.lower);
        result = 37 * result + (int)Double.doubleToLongBits(this.upper);
        return result;
    }

    public String toString() {
        return "lower=" + this.lower + ", upper=" + this.upper;
    }
}

