/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.List;
import org.csstudio.swt.xygraph.Messages;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.toolbar.AnnotationConfigPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddAnnotationDialog
extends Dialog {
    private AnnotationConfigPage configPage;

    protected AddAnnotationDialog(Shell parentShell, XYGraph xyGraph) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        int num = xyGraph.getPlotArea().getAnnotationList().size();
        String name = String.valueOf(Messages.Annotation_DefaultNameFmt) + (num + 1);
        List<Trace> traces = xyGraph.getPlotArea().getTraceList();
        Annotation annotation = traces.size() > 0 ? new Annotation(name, traces.get(0)) : new Annotation(name, xyGraph.primaryXAxis, xyGraph.primaryYAxis);
        this.configPage = new AnnotationConfigPage(xyGraph, annotation);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Annotation_Add);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent_composite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent_composite, 0);
        this.configPage.createPage(composite);
        return parent_composite;
    }

    protected void okPressed() {
        this.configPage.applyChanges();
        super.okPressed();
    }

    public Annotation getAnnotation() {
        return this.configPage.getAnnotation();
    }
}

