/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleInputText {
    private Text text;
    private String previousText;
    private Range range;

    public DoubleInputText(Composite parent, int style) {
        this.text = new Text(parent, style);
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DoubleInputText.this.previousText = DoubleInputText.this.text.getText();
            }

            public void focusLost(FocusEvent e) {
                try {
                    double acceptedValue = Double.parseDouble(DoubleInputText.this.text.getText());
                    if (DoubleInputText.this.range != null) {
                        if (acceptedValue > DoubleInputText.this.range.getUpper()) {
                            acceptedValue = DoubleInputText.this.range.getUpper();
                        } else if (acceptedValue < DoubleInputText.this.range.getLower()) {
                            acceptedValue = DoubleInputText.this.range.getLower();
                        }
                    }
                    DoubleInputText.this.text.setText(String.valueOf(acceptedValue));
                }
                catch (Exception exception) {
                    DoubleInputText.this.text.setText(DoubleInputText.this.previousText);
                    return;
                }
            }
        });
    }

    public DoubleInputText(Composite parent, int style, double max, double min) {
        this(parent, style);
        this.range = new Range(min, max);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Text getText() {
        return this.text;
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.text.getText());
    }
}

