/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.toolbar;

import java.util.Arrays;
import org.csstudio.swt.xygraph.figures.Axis;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class TraceConfigPage {
    private XYGraph xyGraph;
    private Trace trace;
    private Text nameText;
    private Combo xAxisCombo;
    private Combo yAxisCombo;
    private ColorSelector traceColorSelector;
    private Combo traceTypeCombo;
    private Spinner lineWidthSpinner;
    private Combo pointStyleCombo;
    private Spinner pointSizeSpinner;
    private Combo baseLineCombo;
    private Spinner areaAlphaSpinner;
    private Button antiAliasing;
    private Button errorBarEnabledButton;
    private Combo xErrorBarTypeCombo;
    private Combo yErrorBarTypeCombo;
    private ColorSelector errorBarColorSelector;
    private Spinner errorBarCapWidthSpinner;
    private Button drawYErrorInAreaButton;
    private Composite composite;

    public TraceConfigPage(XYGraph xyGraph, Trace trace) {
        this.xyGraph = xyGraph;
        this.trace = trace;
    }

    public void createPage(Composite composite) {
        this.composite = composite;
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite traceCompo = new Composite(composite, 0);
        traceCompo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        traceCompo.setLayout((Layout)new GridLayout(3, false));
        Group errorBarGroup = new Group(composite, 0);
        errorBarGroup.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        errorBarGroup.setLayout((Layout)new GridLayout(2, false));
        errorBarGroup.setText("Error Bar");
        GridData labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        Label nameLabel = new Label(traceCompo, 0);
        nameLabel.setText("Name: ");
        nameLabel.setLayoutData((Object)labelGd);
        this.nameText = new Text(traceCompo, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.nameText.setLayoutData((Object)gd);
        Label xAxisLabel = new Label(traceCompo, 0);
        xAxisLabel.setText("X-Axis: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        xAxisLabel.setLayoutData((Object)labelGd);
        this.xAxisCombo = new Combo(traceCompo, 4);
        for (Axis axis : this.xyGraph.getXAxisList()) {
            this.xAxisCombo.add(axis.getTitle());
        }
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.xAxisCombo.setLayoutData((Object)gd);
        Label yAxisLabel = new Label(traceCompo, 0);
        yAxisLabel.setText("Y-Axis: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        yAxisLabel.setLayoutData((Object)labelGd);
        this.yAxisCombo = new Combo(traceCompo, 4);
        for (Axis axis : this.xyGraph.getYAxisList()) {
            this.yAxisCombo.add(axis.getTitle());
        }
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.yAxisCombo.setLayoutData((Object)gd);
        Label traceColorLabel = new Label(traceCompo, 0);
        traceColorLabel.setText("Trace Color: ");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        traceColorLabel.setLayoutData((Object)labelGd);
        this.traceColorSelector = new ColorSelector(traceCompo);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.traceColorSelector.getButton().setLayoutData((Object)gd);
        Label traceTypeLabel = new Label(traceCompo, 0);
        traceTypeLabel.setText("Trace Type: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        traceTypeLabel.setLayoutData((Object)labelGd);
        this.traceTypeCombo = new Combo(traceCompo, 4);
        this.traceTypeCombo.setItems(Trace.TraceType.stringValues());
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.traceTypeCombo.setLayoutData((Object)gd);
        this.traceTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceConfigPage.this.baseLineCombo.setEnabled(TraceConfigPage.this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.BAR) || TraceConfigPage.this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.AREA));
            }
        });
        Label lineWidthLabel = new Label(traceCompo, 0);
        lineWidthLabel.setText("Line Width (pixels): ");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        lineWidthLabel.setLayoutData((Object)labelGd);
        this.lineWidthSpinner = new Spinner(traceCompo, 2048);
        this.lineWidthSpinner.setMaximum(100);
        this.lineWidthSpinner.setMinimum(0);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.lineWidthSpinner.setLayoutData((Object)gd);
        Label pointStyleLabel = new Label(traceCompo, 0);
        pointStyleLabel.setText("Point Style: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        pointStyleLabel.setLayoutData((Object)labelGd);
        this.pointStyleCombo = new Combo(traceCompo, 4);
        this.pointStyleCombo.setItems(Trace.PointStyle.stringValues());
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.pointStyleCombo.setLayoutData((Object)gd);
        Label pointSizeLable = new Label(traceCompo, 0);
        pointSizeLable.setText("Point Size (pixels): ");
        labelGd = new GridData(4, 0x1000000, false, false, 2, 1);
        pointSizeLable.setLayoutData((Object)labelGd);
        this.pointSizeSpinner = new Spinner(traceCompo, 2048);
        this.pointSizeSpinner.setMaximum(100);
        this.pointSizeSpinner.setMinimum(0);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.pointSizeSpinner.setLayoutData((Object)gd);
        Label baseLineLabel = new Label(traceCompo, 0);
        baseLineLabel.setText("Base Line: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        baseLineLabel.setLayoutData((Object)labelGd);
        baseLineLabel.setToolTipText("The baseline for BAR or AREA trace type");
        this.baseLineCombo = new Combo(traceCompo, 4);
        this.baseLineCombo.setItems(Trace.BaseLine.stringValues());
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        this.baseLineCombo.setLayoutData((Object)gd);
        Label alphaLable = new Label(traceCompo, 0);
        alphaLable.setText("Area Alpha: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        alphaLable.setLayoutData((Object)labelGd);
        this.areaAlphaSpinner = new Spinner(traceCompo, 2048);
        this.areaAlphaSpinner.setMaximum(255);
        this.areaAlphaSpinner.setMinimum(0);
        gd = new GridData(1, 0x1000000, true, false, 2, 1);
        this.areaAlphaSpinner.setLayoutData((Object)gd);
        this.areaAlphaSpinner.setToolTipText("0 for transparent, 255 for opaque");
        this.antiAliasing = new Button(traceCompo, 32);
        this.antiAliasing.setText("Anti Aliasing Enabled");
        this.antiAliasing.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        this.errorBarEnabledButton = new Button((Composite)errorBarGroup, 32);
        this.errorBarEnabledButton.setText("Error Bar Enabled");
        this.errorBarEnabledButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.errorBarEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = TraceConfigPage.this.errorBarEnabledButton.getSelection();
                TraceConfigPage.this.xErrorBarTypeCombo.setEnabled(enabled);
                TraceConfigPage.this.yErrorBarTypeCombo.setEnabled(enabled);
                TraceConfigPage.this.errorBarColorSelector.setEnabled(enabled);
                TraceConfigPage.this.errorBarCapWidthSpinner.setEnabled(enabled);
                TraceConfigPage.this.drawYErrorInAreaButton.setEnabled(enabled);
            }
        });
        Label xErrorBarTypeLabel = new Label((Composite)errorBarGroup, 0);
        xErrorBarTypeLabel.setText("X Error Bar Type: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        xErrorBarTypeLabel.setLayoutData((Object)labelGd);
        this.xErrorBarTypeCombo = new Combo((Composite)errorBarGroup, 4);
        this.xErrorBarTypeCombo.setItems(Trace.ErrorBarType.stringValues());
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.xErrorBarTypeCombo.setLayoutData((Object)gd);
        Label yErrorBarTypeLabel = new Label((Composite)errorBarGroup, 0);
        yErrorBarTypeLabel.setText("Y Error Bar Type: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        yErrorBarTypeLabel.setLayoutData((Object)labelGd);
        this.yErrorBarTypeCombo = new Combo((Composite)errorBarGroup, 4);
        this.yErrorBarTypeCombo.setItems(Trace.ErrorBarType.stringValues());
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.yErrorBarTypeCombo.setLayoutData((Object)gd);
        Label errorBarColorLabel = new Label((Composite)errorBarGroup, 0);
        errorBarColorLabel.setText("Error Bar Color: ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        errorBarColorLabel.setLayoutData((Object)labelGd);
        this.errorBarColorSelector = new ColorSelector((Composite)errorBarGroup);
        gd = new GridData(1, 0x1000000, false, false, 1, 1);
        this.errorBarColorSelector.getButton().setLayoutData((Object)gd);
        Label errorBarCapWidthLabel = new Label((Composite)errorBarGroup, 0);
        errorBarCapWidthLabel.setText("Error Bar Cap Width \n(pixels): ");
        labelGd = new GridData(4, 0x1000000, false, false, 1, 1);
        errorBarCapWidthLabel.setLayoutData((Object)labelGd);
        this.errorBarCapWidthSpinner = new Spinner((Composite)errorBarGroup, 2048);
        this.errorBarCapWidthSpinner.setMaximum(100);
        this.errorBarCapWidthSpinner.setMinimum(0);
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        this.errorBarCapWidthSpinner.setLayoutData((Object)gd);
        this.drawYErrorInAreaButton = new Button((Composite)errorBarGroup, 32);
        this.drawYErrorInAreaButton.setText("Draw Y Error In Area");
        this.drawYErrorInAreaButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.initialize();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void applyChanges() {
        this.trace.setName(this.nameText.getText());
        this.trace.setXAxis(this.xyGraph.getXAxisList().get(this.xAxisCombo.getSelectionIndex()));
        this.trace.setYAxis(this.xyGraph.getYAxisList().get(this.yAxisCombo.getSelectionIndex()));
        this.trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(this.traceColorSelector.getColorValue()));
        this.trace.setTraceType(Trace.TraceType.values()[this.traceTypeCombo.getSelectionIndex()]);
        this.trace.setLineWidth(this.lineWidthSpinner.getSelection());
        this.trace.setPointStyle(Trace.PointStyle.values()[this.pointStyleCombo.getSelectionIndex()]);
        this.trace.setPointSize(this.pointSizeSpinner.getSelection());
        this.trace.setBaseLine(Trace.BaseLine.values()[this.baseLineCombo.getSelectionIndex()]);
        this.trace.setAreaAlpha(this.areaAlphaSpinner.getSelection());
        this.trace.setAntiAliasing(this.antiAliasing.getSelection());
        this.trace.setErrorBarEnabled(this.errorBarEnabledButton.getSelection());
        this.trace.setXErrorBarType(Trace.ErrorBarType.values()[this.xErrorBarTypeCombo.getSelectionIndex()]);
        this.trace.setYErrorBarType(Trace.ErrorBarType.values()[this.yErrorBarTypeCombo.getSelectionIndex()]);
        this.trace.setErrorBarColor(XYGraphMediaFactory.getInstance().getColor(this.errorBarColorSelector.getColorValue()));
        this.trace.setErrorBarCapWidth(this.errorBarCapWidthSpinner.getSelection());
        this.trace.setDrawYErrorInArea(this.drawYErrorInAreaButton.getSelection());
    }

    private void initialize() {
        this.nameText.setText(this.trace.getName());
        this.xAxisCombo.select(this.xyGraph.getXAxisList().indexOf((Object)this.trace.getXAxis()));
        this.yAxisCombo.select(this.xyGraph.getYAxisList().indexOf((Object)this.trace.getYAxis()));
        this.traceColorSelector.setColorValue(this.trace.getTraceColor().getRGB());
        this.traceTypeCombo.select(Arrays.asList(Trace.TraceType.values()).indexOf((Object)this.trace.getTraceType()));
        this.lineWidthSpinner.setSelection(this.trace.getLineWidth());
        this.pointStyleCombo.select(Arrays.asList(Trace.PointStyle.values()).indexOf((Object)this.trace.getPointStyle()));
        this.pointSizeSpinner.setSelection(this.trace.getPointSize());
        this.baseLineCombo.select(Arrays.asList(Trace.BaseLine.values()).indexOf((Object)this.trace.getBaseLine()));
        this.areaAlphaSpinner.setSelection(this.trace.getAreaAlpha());
        this.antiAliasing.setSelection(this.trace.isAntiAliasing());
        this.errorBarEnabledButton.setSelection(this.trace.isErrorBarEnabled());
        this.xErrorBarTypeCombo.select(Arrays.asList(Trace.ErrorBarType.values()).indexOf((Object)this.trace.getXErrorBarType()));
        this.yErrorBarTypeCombo.select(Arrays.asList(Trace.ErrorBarType.values()).indexOf((Object)this.trace.getYErrorBarType()));
        this.errorBarColorSelector.setColorValue(this.trace.getErrorBarColor().getRGB());
        this.errorBarCapWidthSpinner.setSelection(this.trace.getErrorBarCapWidth());
        this.drawYErrorInAreaButton.setSelection(this.trace.isDrawYErrorInArea());
        boolean enabled = this.errorBarEnabledButton.getSelection();
        this.xErrorBarTypeCombo.setEnabled(enabled);
        this.yErrorBarTypeCombo.setEnabled(enabled);
        this.errorBarColorSelector.setEnabled(enabled);
        this.errorBarCapWidthSpinner.setEnabled(enabled);
        this.drawYErrorInAreaButton.setEnabled(enabled);
        this.baseLineCombo.setEnabled(this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.BAR) || this.traceTypeCombo.getSelectionIndex() == Arrays.asList(Trace.TraceType.values()).indexOf((Object)Trace.TraceType.AREA));
    }
}

