/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.undo;

import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.Annotation;
import org.csstudio.swt.xygraph.undo.IUndoableCommand;
import org.eclipse.draw2d.geometry.Point;

public class MovingAnnotationCommand
implements IUndoableCommand {
    private Annotation annotation;
    private Point beforeMovePosition;
    private Point afterMovePosition;
    private ISample beforeMoveSnappedSample;
    private ISample afterMoveSnappedSample;
    private double beforeDx;
    private double beforeDy;
    private double afterDx;
    private double afterDy;

    public MovingAnnotationCommand(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void redo() {
        if (this.annotation.isFree()) {
            this.annotation.setCurrentPosition(this.afterMovePosition, false);
        } else {
            this.annotation.setCurrentSnappedSample(this.afterMoveSnappedSample, false);
        }
        this.annotation.setdxdy(this.afterDx, this.afterDy);
    }

    @Override
    public void undo() {
        if (this.annotation.isFree()) {
            this.annotation.setCurrentPosition(this.beforeMovePosition, false);
        } else {
            this.annotation.setCurrentSnappedSample(this.beforeMoveSnappedSample, false);
        }
        this.annotation.setdxdy(this.beforeDx, this.beforeDy);
    }

    public void setBeforeDxDy(double dx, double dy) {
        this.beforeDx = dx;
        this.beforeDy = dy;
    }

    public void setAfterDxDy(double dx, double dy) {
        this.afterDx = dx;
        this.afterDy = dy;
    }

    public void setBeforeMovePosition(Point beforeMovePosition) {
        this.beforeMovePosition = beforeMovePosition;
    }

    public void setAfterMovePosition(Point afterMovePosition) {
        this.afterMovePosition = afterMovePosition;
    }

    public void setBeforeMoveSnappedSample(ISample beforeMoveSnappedSample) {
        this.beforeMoveSnappedSample = beforeMoveSnappedSample;
    }

    public void setAfterMoveSnappedSample(ISample afterMoveSnappedSample) {
        this.afterMoveSnappedSample = afterMoveSnappedSample;
    }

    public String toString() {
        return "Move Annotation";
    }
}

