/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.undo;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.undo.AnnotationMemento;
import org.csstudio.swt.xygraph.undo.AxisMemento;
import org.csstudio.swt.xygraph.undo.IUndoableCommand;
import org.csstudio.swt.xygraph.undo.TraceMemento;
import org.csstudio.swt.xygraph.undo.XYGraphMemento;
import org.csstudio.swt.xygraph.undo.XYGraphMementoUtil;

public class XYGraphConfigCommand
implements IUndoableCommand {
    private XYGraph xyGraph;
    private XYGraphMemento previousXYGraphMem;
    private XYGraphMemento afterXYGraphMem;

    public XYGraphConfigCommand(XYGraph xyGraph) {
        this.xyGraph = xyGraph;
        this.previousXYGraphMem = new XYGraphMemento();
        this.afterXYGraphMem = new XYGraphMemento();
        int i = 0;
        while (i < xyGraph.getPlotArea().getAnnotationList().size()) {
            this.previousXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            this.afterXYGraphMem.addAnnotationMemento(new AnnotationMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getAxisList().size()) {
            this.previousXYGraphMem.addAxisMemento(new AxisMemento());
            this.afterXYGraphMem.addAxisMemento(new AxisMemento());
            ++i;
        }
        i = 0;
        while (i < xyGraph.getPlotArea().getTraceList().size()) {
            this.previousXYGraphMem.addTraceMemento(new TraceMemento());
            this.afterXYGraphMem.addTraceMemento(new TraceMemento());
            ++i;
        }
    }

    @Override
    public void redo() {
        XYGraphMementoUtil.restoreXYGraphPropsFromMemento(this.xyGraph, this.afterXYGraphMem);
    }

    @Override
    public void undo() {
        XYGraphMementoUtil.restoreXYGraphPropsFromMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void savePreviousStates() {
        XYGraphMementoUtil.saveXYGraphPropsToMemento(this.xyGraph, this.previousXYGraphMem);
    }

    public void saveAfterStates() {
        XYGraphMementoUtil.saveXYGraphPropsToMemento(this.xyGraph, this.afterXYGraphMem);
    }

    public String toString() {
        return "Configure XYGraph Settings";
    }
}

