/*
 * Decompiled with CFR 0.152.
 */
package org.csstudio.swt.xygraph.util;

import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.util.SingleSourceHelper;
import org.csstudio.swt.xygraph.util.XYGraphMediaFactory;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class SingleSourceHelperImpl
extends SingleSourceHelper {
    @Override
    protected Cursor createInternalCursor(Display display, ImageData imageData, int width, int height, int style) {
        return new Cursor((Device)display, imageData, width, height);
    }

    @Override
    protected Image createInternalVerticalTextImage(String text, Font font, RGB color, boolean upToDown) {
        Dimension titleSize = FigureUtilities.getTextExtents((String)text, (Font)font);
        int w = titleSize.height;
        int h = titleSize.width + 1;
        Image image = new Image((Device)Display.getCurrent(), w, h);
        GC gc = new GC((Drawable)image);
        Color titleColor = new Color((Device)Display.getCurrent(), color);
        RGB transparentRGB = new RGB(240, 240, 240);
        gc.setBackground(XYGraphMediaFactory.getInstance().getColor(transparentRGB));
        gc.fillRectangle(image.getBounds());
        gc.setForeground(titleColor);
        gc.setFont(font);
        Transform tr = new Transform((Device)Display.getCurrent());
        if (!upToDown) {
            tr.translate(0.0f, (float)h);
            tr.rotate(-90.0f);
            gc.setTransform(tr);
        } else {
            tr.translate((float)w, 0.0f);
            tr.rotate(90.0f);
            gc.setTransform(tr);
        }
        gc.drawText(text, 0, 0);
        tr.dispose();
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        titleColor.dispose();
        imageData.transparentPixel = imageData.palette.getPixel(transparentRGB);
        image = new Image((Device)Display.getCurrent(), imageData);
        return image;
    }

    @Override
    protected Image getInternalXYGraphSnapShot(XYGraph xyGraph) {
        Rectangle bounds = xyGraph.getBounds();
        Image image = new Image(null, bounds.width + 6, bounds.height + 6);
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        graphics.translate(-bounds.x + 3, -bounds.y + 3);
        graphics.setForegroundColor(xyGraph.getForegroundColor());
        graphics.setBackgroundColor(xyGraph.getBackgroundColor());
        xyGraph.paint((Graphics)graphics);
        gc.dispose();
        return image;
    }

    @Override
    protected String getInternalImageSavePath() {
        FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
        dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
        String path = dialog.open();
        return path;
    }
}

