/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import scouter.client.ApplicationWorkbenchAdvisor;
import scouter.client.net.LoginMgr;
import scouter.client.net.LoginResult;
import scouter.client.popup.LoginDialog2;
import scouter.client.preferences.ServerPrefUtil;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ClientFileUtil;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Location instanceLocation = Platform.getInstanceLocation();
        String workspaceRootName = instanceLocation.getURL().getFile();
        String importWorkingDirName = String.valueOf(workspaceRootName) + File.separator + "import-working";
        try {
            ClientFileUtil.copy(new File(String.valueOf(importWorkingDirName) + File.separator + "xlogcolumnfile"), new File(String.valueOf(workspaceRootName) + File.separator + "xlogcolumnfile"));
            ClientFileUtil.copy(new File(String.valueOf(importWorkingDirName) + File.separator + "groupfile"), new File(String.valueOf(workspaceRootName) + File.separator + "groupfile"));
            ClientFileUtil.copy(new File(String.valueOf(importWorkingDirName) + File.separator + ".metadata"), new File(String.valueOf(workspaceRootName) + File.separator + ".metadata"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClientFileUtil.deleteDirectory(new File(importWorkingDirName));
        Display display = PlatformUI.createDisplay();
        Object exitStrategy = IApplication.EXIT_OK;
        try {
            boolean loginSuccessed = this.loginAutomaticallyWhenAutoLoginEnabled();
            if (!loginSuccessed) {
                loginSuccessed = this.openLoginDialog(display);
            }
            if (loginSuccessed) {
                exitStrategy = this.createAndRunWorkbench(display);
            }
            Integer n = exitStrategy;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private boolean openLoginDialog(Display display) {
        LoginDialog2 dialog = new LoginDialog2(display.getActiveShell(), (serverAddr, serverId) -> {
            Server server = ServerManager.getInstance().getServer(serverId);
            ServerPrefUtil.storeDefaultServer(String.valueOf(server.getIp()) + ":" + server.getPort());
            ServerManager.getInstance().setDefaultServer(server);
        }, 991, null, null);
        return dialog.open() == 0;
    }

    private boolean loginAutomaticallyWhenAutoLoginEnabled() {
        boolean autoLogined = false;
        String[] serverList = ServerPrefUtil.getStoredServerList();
        if (serverList != null && serverList.length > 0) {
            String[] autoList = ServerPrefUtil.getStoredAutoLoginServerList();
            HashSet<Object> autoSet = new HashSet();
            if (autoList != null && autoList.length > 0) {
                autoSet = new HashSet<String>(Arrays.asList(autoList));
            }
            String defaultSrv = ServerPrefUtil.getStoredDefaultServer();
            ServerManager manager = ServerManager.getInstance();
            String[] stringArray = serverList;
            int n = serverList.length;
            int n2 = 0;
            while (n2 < n) {
                String addr = stringArray[n2];
                String[] iport = addr.split(":");
                if (iport.length >= 2) {
                    int index;
                    String accountInfo;
                    String socksIp = null;
                    String socksPort = null;
                    if (ServerPrefUtil.isSocksLogin(addr)) {
                        String socksAddr = ServerPrefUtil.getStoredSocksServer(addr);
                        String[] socksAddrs = socksAddr.split(":");
                        socksIp = socksAddrs[0];
                        socksPort = socksAddrs[1];
                    }
                    Server server = new Server(iport[0], iport[1], null, socksIp, socksPort);
                    if (addr.equals(defaultSrv)) {
                        manager.setDefaultServer(server);
                    } else {
                        manager.addServer(server);
                    }
                    if (autoSet.contains(addr) && (accountInfo = ServerPrefUtil.getStoredAccountInfo(addr)) != null && (index = accountInfo.indexOf(",")) > -1) {
                        String id = accountInfo.substring(0, index);
                        String pwd = accountInfo.substring(index + 1);
                        LoginResult result = LoginMgr.silentLogin(server, id, pwd);
                        if (result.success) {
                            autoLogined = true;
                        }
                    }
                }
                ++n2;
            }
            if (autoLogined && !autoSet.contains(defaultSrv)) {
                Set<Integer> openSet = manager.getOpenServerList();
                Integer[] array = openSet.toArray(new Integer[openSet.size()]);
                Server server = manager.getServer(array[0]);
                ServerPrefUtil.storeDefaultServer(String.valueOf(server.getIp()) + ":" + server.getPort());
                ServerManager.getInstance().setDefaultServer(server);
            }
        }
        return autoLogined;
    }

    private Object createAndRunWorkbench(Display display) {
        int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
        if (returnCode == 1) {
            return IApplication.EXIT_RESTART;
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }
}

