/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import scouter.client.Images;
import scouter.client.actions.AddServerAction;
import scouter.client.actions.ExportWorkspaceAction;
import scouter.client.actions.ImportWorkspaceAction;
import scouter.client.actions.OpenAlertRealTimeAction;
import scouter.client.actions.OpenClientEnvViewAction;
import scouter.client.actions.OpenClientThreadListAction;
import scouter.client.actions.OpenConsoleAction;
import scouter.client.actions.OpenGroupNavigationAction;
import scouter.client.actions.OpenObjectDashboardAction;
import scouter.client.actions.OpenServerManagerAction;
import scouter.client.actions.OpenWorkspaceExplorerAction;
import scouter.client.actions.RestartAction;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        Server server = ServerManager.getInstance().getDefaultServer();
        int serverId = 0;
        if (server != null) {
            serverId = server.getId();
        }
        this.register((IAction)new OpenClientThreadListAction(window, "Client Thread List", Images.thread));
        this.register((IAction)new OpenClientEnvViewAction(window));
        this.register((IAction)new OpenWorkspaceExplorerAction(window, "Workspace Explorer", Images.explorer, serverId));
        this.register((IAction)new ExportWorkspaceAction(window, "Export perspective settings", Images.explorer));
        this.register((IAction)new ImportWorkspaceAction(window, "Import perspective settings", Images.explorer));
        this.register((IAction)new RestartAction(window, "Restart"));
        this.register((IAction)new AddServerAction(window, "Add Server", Images.add));
        this.register((IAction)new OpenServerManagerAction());
        this.register((IAction)new OpenObjectDashboardAction(window, "Object Dashboard"));
        this.register((IAction)new OpenConsoleAction(window, "Console"));
        this.register((IAction)new OpenAlertRealTimeAction(window, "Alert", Images.alert));
        this.register((IAction)new OpenGroupNavigationAction(window));
        this.register((IAction)ActionFactory.RESET_PERSPECTIVE.create(window));
    }

    public IAction getAction(String id) {
        return super.getAction(id);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
    }
}

