/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import java.util.TimeZone;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import scouter.Version;
import scouter.client.Activator;
import scouter.client.ApplicationActionBarAdvisor;
import scouter.client.misc.UpdateCheckScheduler;
import scouter.client.notice.NoticeCheckScheduler;
import scouter.client.remote.CheckMyJob;
import scouter.client.threads.AlertProxyThread;
import scouter.client.threads.SessionObserver;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private ApplicationActionBarAdvisor actionBarAdvisor;
    Display display;
    IWorkbenchWindowConfigurer configurer;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.actionBarAdvisor = new ApplicationActionBarAdvisor(configurer);
        return this.actionBarAdvisor;
    }

    public void preWindowOpen() {
        this.configurer = this.getWindowConfigurer();
        this.configurer.setInitialSize(new Point(1440, 900));
        this.configurer.setShowMenuBar(true);
        this.configurer.setShowCoolBar(false);
        this.configurer.setShowStatusLine(true);
        this.configurer.setShowProgressIndicator(true);
        this.configurer.setShowPerspectiveBar(true);
        this.configurer.setTitle("Version - " + Version.getClientFullVersion() + "(" + TimeZone.getDefault().getDisplayName() + ")");
    }

    public void postWindowOpen() {
        super.postWindowOpen();
    }

    public void dispose() {
        super.dispose();
    }

    public void postWindowRestore() throws WorkbenchException {
        super.postWindowRestore();
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        boolean isrcp = false;
        if (Platform.getProduct() != null) {
            if (Activator.PRODUCT_ID.equals(Platform.getProduct().getId()) && Activator.APPLICATION_ID.equals(Platform.getProduct().getApplication())) {
                isrcp = true;
            }
        } else if (Activator.APPLICATION_ID.equals(System.getProperty("eclipse.application"))) {
            isrcp = true;
        }
        if (isrcp) {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.getWindow().getShell().setMaximized(true);
            this.startBackgroundJob();
        }
    }

    private void startBackgroundJob() {
        CheckMyJob.getInstance();
        SessionObserver.load();
        AlertProxyThread.getInstance();
        NoticeCheckScheduler.INSTANCE.initialize();
        UpdateCheckScheduler.INSTANCE.initialize();
    }
}

