/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.cubrid.views.CubridLongTransactionList;
import scouter.client.cubrid.views.CubridRealtimeDmlView;
import scouter.client.cubrid.views.CubridServerInfoView;
import scouter.client.cubrid.views.CubridSingleRealTimeMultiView;
import scouter.client.cubrid.views.CubridSpaceDbView;
import scouter.client.group.view.GroupNavigationView;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.views.AlertView;
import scouter.client.views.ObjectDailyListView;
import scouter.client.views.ObjectNavigationView;
import scouter.client.views.WorkspaceExplorer;

public class PerspectiveCubrid
implements IPerspectiveFactory {
    public static final String ID = PerspectiveCubrid.class.getName();

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        layout.setEditorAreaVisible(false);
        Server server = ServerManager.getInstance().getDefaultServer();
        int serverId = server.getId();
        IFolderLayout agentLayout = layout.createFolder("perspective.database.objnavigation", 1, 0.3f, editorArea);
        agentLayout.addPlaceholder(String.valueOf(ObjectNavigationView.ID) + ":*");
        agentLayout.addPlaceholder(String.valueOf(ObjectDailyListView.ID) + ":*");
        agentLayout.addPlaceholder(WorkspaceExplorer.ID);
        agentLayout.addPlaceholder(GroupNavigationView.ID);
        agentLayout.addView(ObjectNavigationView.ID);
        layout.getViewLayout(ObjectNavigationView.ID).setCloseable(false);
        IFolderLayout consoleLayout = layout.createFolder("perspective.database.console", 4, 0.5f, "perspective.database.objnavigation");
        consoleLayout.addView("org.eclipse.ui.console.ConsoleView");
        IFolderLayout alertLayout = layout.createFolder("perspective.database.alert", 3, 0.5f, "perspective.database.console");
        alertLayout.addView(AlertView.ID);
        IFolderLayout layout1 = layout.createFolder("perspective.cubrid.serverinfo", 1, 0.4f, editorArea);
        layout1.addView(String.valueOf(CubridServerInfoView.ID) + ":" + serverId);
        layout.getViewLayout(String.valueOf(CubridServerInfoView.ID) + ":" + serverId).setCloseable(false);
        IFolderLayout layout3 = layout.createFolder("perspective.cubrid.multiview.xaslplan", 4, 0.2f, "perspective.cubrid.serverinfo");
        layout3.addView(String.valueOf(CubridSingleRealTimeMultiView.ID) + ":" + serverId + "&" + "default" + "&" + CubridSingleItem.XASL_PLAN_HIT_RATE.ordinal() + "&" + 600000L);
        IFolderLayout layout4 = layout.createFolder("perspective.cubrid.multiview.tps", 4, 0.3f, "perspective.cubrid.multiview.xaslplan");
        layout4.addView(String.valueOf(CubridSingleRealTimeMultiView.ID) + ":" + serverId + "&" + "default" + "&" + CubridSingleItem.TPS.ordinal() + "&" + 600000L);
        IFolderLayout layout5 = layout.createFolder("perspective.cubrid.multiview.qps", 4, 0.5f, "perspective.cubrid.multiview.tps");
        layout5.addView(String.valueOf(CubridSingleRealTimeMultiView.ID) + ":" + serverId + "&" + "default" + "&" + CubridSingleItem.QPS.ordinal() + "&" + 600000L);
        IFolderLayout layout6 = layout.createFolder("perspective.cubrid.mutiview.pagefetches", 2, 0.3f, editorArea);
        layout6.addView(String.valueOf(CubridSingleRealTimeMultiView.ID) + ":" + serverId + "&" + "default" + "&" + CubridSingleItem.DATA_PAGE_FETCHES.ordinal() + "&" + 600000L);
        IFolderLayout layout7 = layout.createFolder("perspective.cubrid.longtran", 4, 0.3f, "perspective.cubrid.mutiview.pagefetches");
        layout7.addView(String.valueOf(CubridLongTransactionList.ID) + ":" + serverId + "&" + "default");
        IFolderLayout layout8 = layout.createFolder("perspective.cubrid.mutiview.pageiowrite", 3, 0.3f, "perspective.cubrid.longtran");
        layout8.addView(String.valueOf(CubridSingleRealTimeMultiView.ID) + ":" + serverId + "&" + "default" + "&" + CubridSingleItem.DATA_PAGE_IO_WRITES.ordinal() + "&" + 600000L);
        IFolderLayout layout9 = layout.createFolder("perspective.cubrid.dmlview", 4, 0.4f, "perspective.cubrid.longtran");
        layout9.addView(String.valueOf(CubridRealtimeDmlView.ID) + ":" + serverId + "&" + "default");
        IFolderLayout layout2 = layout.createFolder("perspective.cubrid.dbspaceinfo", 2, 0.5f, "perspective.cubrid.serverinfo");
        layout2.addView(String.valueOf(CubridSpaceDbView.ID) + ":" + serverId + "&" + "default");
        layout.addPerspectiveShortcut(PerspectiveCubrid.getId());
    }

    public static String getId() {
        return ID;
    }
}

