/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import scouter.client.group.view.GroupNavigationView;
import scouter.client.maria.views.DbDailyTotalConnView;
import scouter.client.maria.views.DbRealtimeTotalActivityView;
import scouter.client.maria.views.DbRealtimeTotalConnView;
import scouter.client.maria.views.DbRealtimeTotalHitRatioView;
import scouter.client.maria.views.DbRealtimeTotalResponseView;
import scouter.client.maria.views.DbTodayTotalActivityView;
import scouter.client.maria.views.DbTodayTotalConnView;
import scouter.client.maria.views.DigestTableView;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.views.AlertView;
import scouter.client.views.ObjectDailyListView;
import scouter.client.views.ObjectNavigationView;
import scouter.client.views.WorkspaceExplorer;

public class PerspectiveMaria
implements IPerspectiveFactory {
    public static final String ID = PerspectiveMaria.class.getName();

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        layout.setEditorAreaVisible(false);
        Server server = ServerManager.getInstance().getDefaultServer();
        int serverId = server.getId();
        IFolderLayout agentLayout = layout.createFolder("perspective.database.objnavigation", 1, 0.2f, editorArea);
        agentLayout.addPlaceholder(String.valueOf(ObjectNavigationView.ID) + ":*");
        agentLayout.addPlaceholder(String.valueOf(ObjectDailyListView.ID) + ":*");
        agentLayout.addPlaceholder(WorkspaceExplorer.ID);
        agentLayout.addPlaceholder(GroupNavigationView.ID);
        agentLayout.addView(ObjectNavigationView.ID);
        layout.getViewLayout(ObjectNavigationView.ID).setCloseable(false);
        IFolderLayout consoleLayout = layout.createFolder("perspective.database.console", 4, 0.4f, "perspective.database.objnavigation");
        consoleLayout.addView("org.eclipse.ui.console.ConsoleView");
        IFolderLayout alertLayout = layout.createFolder("perspective.database.alert", 3, 0.6f, "perspective.database.console");
        alertLayout.addView(AlertView.ID);
        IFolderLayout bottomLayout = layout.createFolder("perspective.database.digesttable", 4, 0.65f, editorArea);
        bottomLayout.addView(String.valueOf(DigestTableView.ID) + ":" + serverId);
        IFolderLayout layout1 = layout.createFolder("perspective.mariadb.conn", 3, 0.5f, editorArea);
        layout1.addPlaceholder(String.valueOf(DbTodayTotalConnView.ID) + ":*");
        layout1.addPlaceholder(String.valueOf(DbDailyTotalConnView.ID) + ":*");
        layout1.addView(String.valueOf(DbRealtimeTotalConnView.ID) + ":" + serverId);
        IFolderLayout layout2 = layout.createFolder("perspective.mariadb.elapsed", 4, 0.5f, "perspective.mariadb.conn");
        layout2.addView(String.valueOf(DbRealtimeTotalResponseView.ID) + ":" + serverId);
        IFolderLayout layout3 = layout.createFolder("perspective.mariadb.activity", 2, 0.5f, "perspective.mariadb.conn");
        layout3.addPlaceholder(String.valueOf(DbTodayTotalActivityView.ID) + ":*");
        layout3.addView(String.valueOf(DbRealtimeTotalActivityView.ID) + ":" + serverId);
        IFolderLayout layout4 = layout.createFolder("perspective.mariadb.hitratio", 2, 0.5f, "perspective.mariadb.elapsed");
        layout4.addView(String.valueOf(DbRealtimeTotalHitRatioView.ID) + ":" + serverId);
        layout.addPerspectiveShortcut(PerspectiveMaria.getId());
    }

    public static String getId() {
        return ID;
    }
}

