/*
 * Decompiled with CFR 0.152.
 */
package scouter.client;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import scouter.client.counter.views.CounterRealTimeAllView;
import scouter.client.counter.views.CounterRealTimeTotalView;
import scouter.client.group.view.GroupNavigationView;
import scouter.client.preferences.PManager;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.views.AlertView;
import scouter.client.views.EQView;
import scouter.client.views.ObjectDailyListView;
import scouter.client.views.ObjectNavigationView;
import scouter.client.views.WorkspaceExplorer;
import scouter.client.xlog.views.XLogRealTimeView;

public class PerspectiveService
implements IPerspectiveFactory {
    public static final String ID = PerspectiveService.class.getName();

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        layout.setEditorAreaVisible(false);
        String host = PManager.getInstance().getString("wasServiceDefaultHost");
        String objType = PManager.getInstance().getString("wasServiceDefaultWAS");
        Server server = ServerManager.getInstance().getDefaultServer();
        int serverId = 0;
        if (server != null) {
            serverId = server.getId();
        }
        IFolderLayout agentLayout = layout.createFolder("scouter.client.perspective.wasservice.objectNavigation", 1, 0.2f, editorArea);
        agentLayout.addPlaceholder(String.valueOf(ObjectNavigationView.ID) + ":*");
        agentLayout.addPlaceholder(String.valueOf(ObjectDailyListView.ID) + ":*");
        agentLayout.addPlaceholder(WorkspaceExplorer.ID);
        agentLayout.addPlaceholder(GroupNavigationView.ID);
        agentLayout.addView(ObjectNavigationView.ID);
        layout.getViewLayout(ObjectNavigationView.ID).setCloseable(false);
        IFolderLayout eqLayout = layout.createFolder("scouter.client.perspective.wasservice.eq", 4, 0.5f, "scouter.client.perspective.wasservice.objectNavigation");
        eqLayout.addPlaceholder(String.valueOf(EQView.ID) + ":*");
        eqLayout.addView(String.valueOf(EQView.ID) + ":" + serverId + "&" + objType);
        IFolderLayout cpuLayout = layout.createFolder("scouter.client.perspective.wasservice.cpu", 4, 0.5f, "scouter.client.perspective.wasservice.eq");
        cpuLayout.addView(String.valueOf(CounterRealTimeAllView.ID) + ":" + serverId + "&" + host + "&" + "Cpu");
        IFolderLayout alertLayout = layout.createFolder("scouter.client.perspective.wasservice.alert", 4, 0.5f, "scouter.client.perspective.wasservice.objectNavigation");
        alertLayout.addPlaceholder(String.valueOf(AlertView.ID) + ":*");
        alertLayout.addView(AlertView.ID);
        IFolderLayout upResLayout = layout.createFolder("scouter.client.perspective.wasservice.leftTop", 1, 0.3f, editorArea);
        upResLayout.addView(String.valueOf(CounterRealTimeAllView.ID) + ":" + serverId + "&" + objType + "&" + "RecentUser");
        IFolderLayout midResLayout = layout.createFolder("scouter.client.perspective.wasservice.leftMiddle1", 4, 0.25f, "scouter.client.perspective.wasservice.leftTop");
        midResLayout.addView(String.valueOf(CounterRealTimeTotalView.ID) + ":" + serverId + "&" + objType + "&" + "TPS");
        IFolderLayout mid2ResLayout = layout.createFolder("scouter.client.perspective.wasservice.leftMiddle2", 4, 0.33f, "scouter.client.perspective.wasservice.leftMiddle1");
        mid2ResLayout.addView(String.valueOf(CounterRealTimeAllView.ID) + ":" + serverId + "&" + objType + "&" + "ElapsedTime");
        IFolderLayout downResLayout = layout.createFolder("scouter.client.perspective.wasservice.leftBottom", 4, 0.5f, "scouter.client.perspective.wasservice.leftMiddle2");
        downResLayout.addView(String.valueOf(CounterRealTimeAllView.ID) + ":" + serverId + "&" + objType + "&" + "HeapUsed");
        IFolderLayout xlogTopLayout = layout.createFolder("scouter.client.perspective.wasservice.centerTop", 1, 1.0f, editorArea);
        xlogTopLayout.addView(String.valueOf(XLogRealTimeView.ID) + ":" + serverId + "&" + objType);
        layout.addPerspectiveShortcut(PerspectiveService.getId());
    }

    public static String getId() {
        return ID;
    }
}

