/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.mihalis.opal.utils.StringUtil;
import scouter.client.util.ClientFileUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ZipUtil;
import scouter.util.FileUtil;

public class ExportWorkspaceAction
extends Action {
    public static final String ID = ExportWorkspaceAction.class.getName();
    private final IWorkbenchWindow window;

    public ExportWorkspaceAction(IWorkbenchWindow window, String label, Image image) {
        this.window = window;
        this.setText(label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            String message = "It may be lost that you make change in this session.\nIf you want to export all settings made in this session,\nplease restart and try again.\nOr if you didn't make any change in this session, just try it";
            if (!MessageDialog.openConfirm((Shell)this.window.getShell(), (String)"Confirm", (String)message)) {
                return;
            }
            FileDialog dialog = new FileDialog(this.window.getShell(), 8192);
            dialog.setFilterNames(new String[]{"scouter export zip files", "zip Files (*.zip)"});
            dialog.setFilterExtensions(new String[]{"*.zip", "*.*"});
            dialog.setFileName("scouter-client-export-workspace.zip");
            dialog.setOverwrite(true);
            String exportFileName = dialog.open();
            if (StringUtil.isEmpty((String)exportFileName)) {
                return;
            }
            String workspaceRootName = Platform.getInstanceLocation().getURL().getFile();
            String exportWorkingDirName = String.valueOf(workspaceRootName) + "/export-working";
            new Thread(() -> {
                ClientFileUtil.deleteDirectory(new File(exportWorkingDirName));
                FileUtil.mkdirs((String)exportWorkingDirName);
                try {
                    ClientFileUtil.copy(new File(String.valueOf(workspaceRootName) + "/" + "xlogcolumnfile"), new File(String.valueOf(exportWorkingDirName) + "/" + "xlogcolumnfile"));
                    ClientFileUtil.copy(new File(String.valueOf(workspaceRootName) + "/" + "groupfile"), new File(String.valueOf(exportWorkingDirName) + "/" + "groupfile"));
                    ClientFileUtil.copy(new File(String.valueOf(workspaceRootName) + "/" + ".metadata"), new File(String.valueOf(exportWorkingDirName) + "/" + ".metadata"));
                    ClientFileUtil.deleteFile(new File(String.valueOf(exportWorkingDirName) + "/" + ".metadata/.log"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    ZipUtil.compress(exportWorkingDirName, exportFileName);
                    ClientFileUtil.deleteDirectory(new File(exportWorkingDirName));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }).start();
        }
    }
}

