/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.util.ClientFileUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.ZipUtil;
import scouter.util.FileUtil;
import scouter.util.StringUtil;

public class ImportWorkspaceAction
extends Action {
    public static final String ID = ImportWorkspaceAction.class.getName();
    private final IWorkbenchWindow window;

    public ImportWorkspaceAction(IWorkbenchWindow window, String label, Image image) {
        this.window = window;
        this.setText(label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            FileDialog dialog = new FileDialog(this.window.getShell(), 4096);
            dialog.setFilterNames(new String[]{"scouter export zip files", "zip Files (*.zip)"});
            dialog.setFilterExtensions(new String[]{"*.zip"});
            String importFileName = dialog.open();
            if (StringUtil.isEmpty((String)importFileName)) {
                return;
            }
            String workspaceRootName = Platform.getInstanceLocation().getURL().getFile();
            String importWorkingDirName = String.valueOf(workspaceRootName) + "/import-working";
            ClientFileUtil.deleteDirectory(new File(importWorkingDirName));
            FileUtil.mkdirs((String)importWorkingDirName);
            try {
                ZipUtil.decompress(importFileName, importWorkingDirName);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            String message = "Import completed.\nRestarting...";
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)"Info", (String)message);
            ExUtil.exec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().restart();
                }
            });
        }
    }
}

