/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.util.ImageUtil;
import scouter.client.views.ObjectActiveServiceListView;

public class OpenActiveServiceListAction
extends Action {
    public static final String ID = OpenActiveServiceListAction.class.getName();
    private final IWorkbenchWindow window;
    private String objType;
    private int serverId;

    public OpenActiveServiceListAction(IWorkbenchWindow window, String objType, Image image, int serverId) {
        this.window = window;
        this.serverId = serverId;
        this.setText("Active Service List");
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
        this.objType = objType;
    }

    public void run() {
        if (this.window != null) {
            try {
                this.window.getActivePage().showView(ObjectActiveServiceListView.ID, String.valueOf(this.serverId) + "&" + this.objType, 1);
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

