/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.popup.CalendarDialog;
import scouter.client.util.ImageUtil;
import scouter.client.views.ObjectDailyListView;

public class OpenObjectDailyListAction
extends Action
implements CalendarDialog.ILoadCalendarDialog {
    public static final String ID = OpenObjectDailyListAction.class.getName();
    private final IWorkbenchWindow window;
    private int serverId;

    public OpenObjectDailyListAction(IWorkbenchWindow window, String label, Image image, int serverId) {
        this.window = window;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            CalendarDialog dialog = new CalendarDialog(this.window.getShell().getDisplay(), this);
            dialog.show();
        }
    }

    @Override
    public void onPressedOk(long startTime, long endTime) {
    }

    @Override
    public void onPressedOk(String date) {
        try {
            ObjectDailyListView v = (ObjectDailyListView)this.window.getActivePage().showView(ObjectDailyListView.ID, Integer.toString(this.serverId), 1);
            if (v != null) {
                v.setInput(date, this.serverId);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
        }
    }

    @Override
    public void onPressedCancel() {
    }
}

