/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.util.ExUtil;
import scouter.client.views.WhiteBoardView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class OpenRedisInfoViewAction
extends Action {
    public static final String ID = OpenRedisInfoViewAction.class.getName();
    private final IWorkbenchWindow window;
    int serverId;
    int objHash;

    public OpenRedisInfoViewAction(IWorkbenchWindow window, int serverId, int objHash) {
        this.window = window;
        this.serverId = serverId;
        this.objHash = objHash;
        this.setText("Info");
    }

    public void run() {
        new LoadRedisInfo().schedule();
    }

    class LoadRedisInfo
    extends Job {
        public LoadRedisInfo() {
            super("Load Redis Info");
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(OpenRedisInfoViewAction.this.serverId);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)OpenRedisInfoViewAction.this.objHash);
                    Pack p = tcp.getSingle("REDIS_INFO", (Pack)param);
                    if (p != null) {
                        MapPack m = (MapPack)p;
                        final String content = m.getText("info");
                        ExUtil.exec(OpenRedisInfoViewAction.this.window.getShell().getDisplay(), new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    WhiteBoardView view = (WhiteBoardView)((LoadRedisInfo)LoadRedisInfo.this).OpenRedisInfoViewAction.this.window.getActivePage().showView(WhiteBoardView.ID, String.valueOf(((LoadRedisInfo)LoadRedisInfo.this).OpenRedisInfoViewAction.this.serverId) + "&" + ((LoadRedisInfo)LoadRedisInfo.this).OpenRedisInfoViewAction.this.objHash, 1);
                                    if (view != null) {
                                        view.setInput("Info[" + TextProxy.object.getText(((LoadRedisInfo)LoadRedisInfo.this).OpenRedisInfoViewAction.this.objHash) + "]", content);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TcpProxy.putTcpProxy(tcp);
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            return Status.OK_STATUS;
        }
    }
}

