/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.util.ImageUtil;
import scouter.client.views.WorkspaceExplorer;

public class OpenWorkspaceExplorerAction
extends Action {
    public static final String ID = OpenWorkspaceExplorerAction.class.getName();
    private final IWorkbenchWindow window;
    private boolean autoRefresh;
    private int serverId;

    public OpenWorkspaceExplorerAction(IWorkbenchWindow window, String label, Image image, int serverId) {
        this.window = window;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public OpenWorkspaceExplorerAction(IWorkbenchWindow window, String label, Image image, boolean autoRefresh, int serverId) {
        this.window = window;
        this.autoRefresh = autoRefresh;
        this.serverId = serverId;
        this.setText(label);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            try {
                WorkspaceExplorer view = (WorkspaceExplorer)this.window.getActivePage().showView(WorkspaceExplorer.ID, null, 1);
                if (this.autoRefresh && view != null) {
                    view.setInput(this.serverId);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

