/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Images;
import scouter.client.model.AgentColorManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.util.ImageUtil;

public class SetColorAction
extends Action {
    public static final String ID = SetColorAction.class.getName();
    private final IWorkbenchWindow window;
    private int objHash;

    public SetColorAction(IWorkbenchWindow window, int objHash) {
        this.window = window;
        this.objHash = objHash;
        this.setText("Set Color");
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.color_swatch));
    }

    public void run() {
        if (this.window != null) {
            ColorDialog dlg = new ColorDialog(this.window.getShell());
            AgentObject agent = AgentModelThread.getInstance().getAgentObject(this.objHash);
            dlg.setRGB(agent.getColor().getRGB());
            dlg.setText("Choose a Color");
            RGB rgb = dlg.open();
            if (rgb != null) {
                Color color = AgentColorManager.getInstance().changeColor(this.objHash, rgb);
            }
        }
    }
}

