/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.batch.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.client.views.ObjectThreadDumpView;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class OpenBatchActiveStackJob
extends Job {
    private String key;
    private int serverId;
    private int objHash;

    public OpenBatchActiveStackJob(String key, int objHash, int serverId) {
        super("Load Batch Active Stack");
        this.key = key;
        this.serverId = serverId;
        this.objHash = objHash;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Load Batch Stack....", -1);
        final String stackText = this.getStackData(this.serverId, this.objHash, this.key);
        if (stackText == null) {
            return Status.CANCEL_STATUS;
        }
        ExUtil.exec(Display.getDefault(), new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ObjectThreadDumpView view = (ObjectThreadDumpView)window.getActivePage().showView(ObjectThreadDumpView.ID, String.valueOf(OpenBatchActiveStackJob.this.objHash) + "&" + TimeUtil.getCurrentTime(OpenBatchActiveStackJob.this.serverId), 1);
                    if (view != null) {
                        view.setInput(stackText);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        return Status.OK_STATUS;
    }

    private String getStackData(int serverId, int objHash, String key) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        String stack = null;
        try {
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            param.put("key", key);
            MapPack map = (MapPack)tcp.getSingle("BATCH_ACTIVE_STACK", (Pack)param);
            if (map == null) {
                return null;
            }
            try {
                stack = map.getText("stack");
            }
            catch (Throwable th) {
                ConsoleProxy.errorSafe(th.toString());
                return null;
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return stack;
    }
}

