/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.batch.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.batch.views.BatchDetailView;
import scouter.client.net.TcpProxy;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class OpenBatchDetailJob
extends Job {
    Display display;
    BatchPack pack;
    int serverId;
    String secId = "batchdetailview";

    public OpenBatchDetailJob(Display display, BatchPack pack, int serverId) {
        super("Load Batch History Detail");
        this.display = display;
        this.pack = pack;
        this.serverId = serverId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Load Batch Detail....", -1);
        final BatchPack recvPack = (BatchPack)this.getPackData(this.serverId, this.pack);
        if (recvPack != null) {
            ExUtil.exec(this.display, new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        BatchDetailView view = (BatchDetailView)win.getActivePage().showView(BatchDetailView.ID, OpenBatchDetailJob.this.secId, 1);
                        view.setInput(recvPack, OpenBatchDetailJob.this.serverId);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    private Pack getPackData(int serverId, BatchPack input) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("objHash", (long)input.objHash);
            param.put("startTime", input.startTime);
            param.put("elapsedTime", input.elapsedTime);
            param.put("position", input.position);
            Pack p = tcp.getSingle("BATCH_HISTORY_DETAIL", (Pack)param);
            if (p != null) {
                Pack pack = p;
                return pack;
            }
        }
        catch (Throwable th) {
            ConsoleProxy.errorSafe(th.toString());
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return null;
    }
}

