/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.batch.actions;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.stack.base.MainProcessor;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.StackUtil;
import scouter.client.views.ObjectThreadDumpView;
import scouter.io.DataInputX;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.MapPack;
import scouter.util.ZipFileUtil;

public class OpenBatchStackJob
extends Job {
    private BatchPack pack;
    private int serverId;
    private boolean isSFA;

    public OpenBatchStackJob(BatchPack pack, int serverId, boolean isSFA) {
        super("Load Batch History Stack");
        this.pack = pack;
        this.serverId = serverId;
        this.isSFA = isSFA;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Load Batch Stack....", -1);
        final String stackfile = this.getStackData(this.serverId, this.pack);
        if (stackfile == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.isSFA) {
            ExUtil.exec(Display.getDefault(), new Runnable(){

                @Override
                public void run() {
                    try {
                        MainProcessor.instance().processStackFile(stackfile);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        } else {
            final String indexFilename = stackfile.subSequence(0, stackfile.length() - 4) + ".inx";
            final List[] lists = this.getStackIndexList(indexFilename);
            if (lists == null || lists[0].size() == 0) {
                return Status.OK_STATUS;
            }
            ExUtil.exec(Display.getDefault(), new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ObjectThreadDumpView view = (ObjectThreadDumpView)window.getActivePage().showView(ObjectThreadDumpView.ID, null, 1);
                        if (view != null) {
                            view.setInput(OpenBatchStackJob.this.pack.objName, indexFilename, lists);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    private String getStackData(int serverId, BatchPack input) {
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        String dirPath = StackUtil.getStackWorkspaceDir(input.objName);
        String filename = this.getStackFilename();
        String logFilename = String.valueOf(dirPath) + filename + ".log";
        if (!new File(logFilename).exists()) {
            String zipFilename = String.valueOf(filename) + ".zip";
            File zipFile = new File(dirPath, zipFilename);
            try {
                try {
                    MapPack param = new MapPack();
                    param.put("objHash", (long)input.objHash);
                    param.put("time", input.startTime);
                    param.put("filename", zipFilename);
                    ZipInputStream zis = null;
                    final BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));
                    try {
                        tcp.process("BATCH_HISTORY_STACK", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                byte[] data = in.readBlob();
                                if (data != null && data.length >= 0) {
                                    out.write(data);
                                }
                            }
                        });
                        out.flush();
                        zis = new ZipInputStream(new FileInputStream(zipFile));
                        ZipFileUtil.recieveZipFile((ZipInputStream)zis, (String)dirPath);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (zis != null) {
                            try {
                                zis.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    zipFile.delete();
                }
                catch (Throwable th) {
                    ConsoleProxy.errorSafe(th.toString());
                    TcpProxy.putTcpProxy(tcp);
                    return null;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
        }
        return logFilename;
    }

    private String getStackFilename() {
        StringBuilder buffer = new StringBuilder(100);
        Date date = new Date(this.pack.startTime);
        buffer.append(this.pack.batchJobId).append('_').append(new SimpleDateFormat("yyyyMMdd").format(date)).append('_').append(new SimpleDateFormat("HHmmss.SSS").format(date)).append('_').append(this.pack.pID);
        return buffer.toString();
    }

    private List<Long>[] getStackIndexList(String filename) {
        ArrayList[] lists;
        block14: {
            File stackfile = new File(filename);
            if (!stackfile.exists()) {
                return null;
            }
            lists = new ArrayList[]{new ArrayList(), new ArrayList()};
            BufferedReader rd = null;
            try {
                try {
                    String line;
                    rd = new BufferedReader(new FileReader(stackfile));
                    while ((line = rd.readLine()) != null) {
                        String[] values = (line = line.trim()).split(" ");
                        if (values.length != 2) continue;
                        long time = Long.parseLong(values[0]);
                        long position = Long.parseLong(values[1]);
                        lists[0].add(time);
                        lists[1].add(position);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (rd == null) break block14;
                    try {
                        rd.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rd != null) {
                    try {
                        rd.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return lists;
    }
}

