/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.batch.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.batch.actions.OpenBatchActiveStackJob;
import scouter.client.model.AgentDataProxy;
import scouter.client.model.BatchData;
import scouter.client.model.RefreshThread;
import scouter.client.model.TextProxy;
import scouter.client.server.ServerManager;
import scouter.client.sorter.TableLabelSorter;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class ObjectBatchActiveListView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = ObjectBatchActiveListView.class.getName();
    private int serverId;
    private String objType;
    private int objHash = 0;
    CounterEngine counterEngine;
    private String key;
    private TableViewer tableViewer;
    private TableColumnLayout tableColumnLayout;
    private Label errorLbl;
    RefreshThread thread;
    boolean autoRefresh = false;
    boolean manulRefresh = true;
    Action openThreadDumpDialog = new Action("Batch Thread Dump View", ImageUtil.getImageDescriptor(Images.thread)){

        public void run() {
            new OpenBatchActiveStackJob(ObjectBatchActiveListView.this.key, ObjectBatchActiveListView.this.objHash, ObjectBatchActiveListView.this.serverId).schedule();
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objType = ids[1];
        if (ids.length > 2) {
            this.objHash = CastUtil.cint((Object)ids[2]);
        }
    }

    public void createPartControl(Composite parent) {
        this.counterEngine = ServerManager.getInstance().getServer(this.serverId).getCounterEngine();
        if (this.objHash == 0) {
            this.setPartName("Batch Active List[" + this.counterEngine.getDisplayNameObjectType(this.objType) + "]");
        } else {
            this.setPartName("Batch Active List[" + TextProxy.object.getText(this.objHash) + "]");
        }
        this.initialLayout(parent);
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                ObjectBatchActiveListView.this.manulRefresh = true;
                ObjectBatchActiveListView.this.thread.interrupt();
            }
        });
        man.add((IContributionItem)new Separator());
        Action actAutoRefresh = new Action("Auto Refresh in 10 sec.", 2){

            public void run() {
                ObjectBatchActiveListView.this.autoRefresh = this.isChecked();
                if (ObjectBatchActiveListView.this.autoRefresh) {
                    ObjectBatchActiveListView.this.thread.interrupt();
                }
            }
        };
        actAutoRefresh.setImageDescriptor(ImageUtil.getImageDescriptor(Images.refresh_auto));
        man.add((IAction)actAutoRefresh);
        this.thread = new RefreshThread(this, 10000);
        this.thread.start();
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.errorLbl = new Label(composite, 0);
        this.errorLbl.setForeground(ColorUtil.getInstance().getColor(3));
        GridData gr = new GridData(4, 4, true, false);
        gr.exclude = true;
        this.errorLbl.setLayoutData((Object)gr);
        this.errorLbl.setVisible(false);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setComparator((ViewerComparator)new TableLabelSorter(this.tableViewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof BatchData) {
                    BatchData data = (BatchData)o;
                    if (!data.lastStack) {
                        return;
                    }
                    ObjectBatchActiveListView.this.key = data.key;
                    ObjectBatchActiveListView.this.openThreadDumpDialog.run();
                }
            }
        });
    }

    @Override
    public void refresh() {
        if (!this.manulRefresh && !this.autoRefresh) {
            return;
        }
        this.manulRefresh = false;
        this.load();
    }

    private void load() {
        List<Pack> packList = AgentDataProxy.getBatchActiveList(this.objType, this.objHash, this.serverId);
        final ArrayList<BatchData> datas = new ArrayList<BatchData>();
        final DecimalValue count = new DecimalValue();
        final StringBuilder error = new StringBuilder();
        for (Pack pack : packList) {
            String objName;
            MapPack mpack = (MapPack)pack;
            boolean complete = mpack.getBoolean("complete");
            int objHash = mpack.getInt("objHash");
            if (!complete && (objName = TextProxy.object.getText(objHash)) != null) {
                error.append(String.valueOf(objName) + " ");
            }
            ListValue keys = mpack.getList("key");
            ListValue batchJobId = mpack.getList("batchJobId");
            ListValue args = mpack.getList("args");
            ListValue pID = mpack.getList("pID");
            ListValue startTime = mpack.getList("startTime");
            ListValue elapsedTime = mpack.getList("elapsedTime");
            ListValue cPUTime = mpack.getList("cPUTime");
            ListValue sqlTotalTime = mpack.getList("sqlTotalTime");
            ListValue sqlTotalRows = mpack.getList("sqlTotalRows");
            ListValue sqlTotalRuns = mpack.getList("sqlTotalRuns");
            ListValue lastStack = mpack.getList("lastStack");
            if (keys != null) {
                int size = keys.size();
                count.value += (long)size;
                int i = 0;
                while (i < size) {
                    BatchData data = new BatchData();
                    data.key = keys.getString(i);
                    data.objHash = objHash;
                    data.batchJobId = batchJobId.getString(i);
                    data.args = args.getString(i);
                    data.pID = (int)pID.getLong(i);
                    data.startTime = startTime.getLong(i);
                    data.elapsedTime = elapsedTime.getLong(i);
                    data.cPUTime = cPUTime.getLong(i);
                    data.sqlTotalTime = sqlTotalTime.getLong(i);
                    data.sqlTotalRows = sqlTotalRows.getLong(i);
                    data.sqlTotalRuns = sqlTotalRuns.getLong(i);
                    data.lastStack = lastStack.getBoolean(i);
                    datas.add(data);
                    ++i;
                }
            }
            Collections.sort(datas, new Comparator<BatchData>(){

                @Override
                public int compare(BatchData o1, BatchData o2) {
                    return o1.elapsedTime > o2.elapsedTime ? -1 : 1;
                }
            });
            int index = 1;
            for (BatchData data : datas) {
                data.id = index++;
            }
        }
        if (error.length() > 0) {
            error.append("may be not loaded.");
        }
        ExUtil.exec((Composite)this.tableViewer.getTable(), new Runnable(){

            @Override
            public void run() {
                ObjectBatchActiveListView.this.setContentDescription("Count = " + count.value);
                if (error.length() > 0) {
                    GridData gr = (GridData)ObjectBatchActiveListView.this.errorLbl.getLayoutData();
                    gr.exclude = false;
                    ObjectBatchActiveListView.this.errorLbl.setVisible(true);
                    ObjectBatchActiveListView.this.errorLbl.setText(error.toString());
                } else {
                    GridData gr = (GridData)ObjectBatchActiveListView.this.errorLbl.getLayoutData();
                    gr.exclude = true;
                    ObjectBatchActiveListView.this.errorLbl.setVisible(false);
                    ObjectBatchActiveListView.this.errorLbl.setText("");
                }
                ObjectBatchActiveListView.this.errorLbl.getParent().layout(false);
                ObjectBatchActiveListView.this.tableViewer.setInput((Object)datas);
            }
        });
    }

    private void createColumns() {
        ColumnEnum[] columnEnumArray = ColumnEnum.values();
        int n = columnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnEnum column = columnEnumArray[n2];
            this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)ObjectBatchActiveListView.this.tableViewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    static enum ColumnEnum {
        NO("NO", 60, 131072, true, true, true, 0),
        OBJNAME("Object Name", 150, 16384, true, true, false, 1),
        BATCHJOBID("Bath Job ID", 150, 16384, true, true, false, 2),
        ARGS("Arguments", 200, 16384, true, true, false, 3),
        PID("PID", 80, 16384, true, true, true, 4),
        STARTTIME("Start Time", 150, 131072, true, true, false, 5),
        ELAPSEDTIME("Elapsed Time", 100, 131072, true, true, true, 6),
        CPUTIME("CPU Time", 100, 131072, true, true, true, 7),
        SQLTOTALTIME("SQL Time", 100, 131072, true, true, true, 8),
        SQLTOTALROWS("SQL Rows", 100, 131072, true, true, true, 9),
        SQLTOTALRUNS("SQL Runs", 100, 131072, true, true, true, 10),
        LASTSTAK("Stack", 70, 0x1000000, true, true, false, 11);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;
        private final int index;

        private ColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber, int index) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
            this.index = index;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof BatchData) {
                BatchData t = (BatchData)element;
                if (t.elapsedTime > 3600000L) {
                    return ColorUtil.getInstance().getColor(3);
                }
                if (t.elapsedTime > 1800000L) {
                    return ColorUtil.getInstance().getColor(11);
                }
                return ColorUtil.getInstance().getColor(9);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BatchData) {
                if (columnIndex == ColumnEnum.NO.getIndex()) {
                    return FormatUtil.print((Object)((BatchData)element).id, (String)"000");
                }
                if (columnIndex == ColumnEnum.OBJNAME.getIndex()) {
                    return TextProxy.object.getText(((BatchData)element).objHash);
                }
                if (columnIndex == ColumnEnum.BATCHJOBID.getIndex()) {
                    return ((BatchData)element).batchJobId;
                }
                if (columnIndex == ColumnEnum.ARGS.getIndex()) {
                    return ((BatchData)element).args;
                }
                if (columnIndex == ColumnEnum.PID.getIndex()) {
                    return String.valueOf(((BatchData)element).pID);
                }
                if (columnIndex == ColumnEnum.STARTTIME.getIndex()) {
                    return String.valueOf(DateUtil.yyyymmdd((long)((BatchData)element).startTime)) + " " + DateUtil.hhmmss((long)((BatchData)element).startTime);
                }
                if (columnIndex == ColumnEnum.ELAPSEDTIME.getIndex()) {
                    return FormatUtil.print((Object)((BatchData)element).elapsedTime, (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.CPUTIME.getIndex()) {
                    return FormatUtil.print((Object)(((BatchData)element).cPUTime / 1000000L), (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.SQLTOTALTIME.getIndex()) {
                    return FormatUtil.print((Object)(((BatchData)element).sqlTotalTime / 1000000L), (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.SQLTOTALROWS.getIndex()) {
                    return FormatUtil.print((Object)((BatchData)element).sqlTotalRows, (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.SQLTOTALRUNS.getIndex()) {
                    return FormatUtil.print((Object)((BatchData)element).sqlTotalRuns, (String)"#,##0");
                }
                if (columnIndex == ColumnEnum.LASTSTAK.getIndex()) {
                    if (((BatchData)element).lastStack) {
                        return "O";
                    }
                    return "";
                }
            }
            return null;
        }
    }
}

