/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.batch.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.batch.actions.OpenBatchDetailJob;
import scouter.client.model.TextProxy;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.TimeUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.MapPack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class ObjectBatchHistoryView
extends ViewPart {
    public static final String ID = ObjectBatchHistoryView.class.getName();
    private int objHash;
    private DateTime date;
    private DateTime fromTime;
    private DateTime toTime;
    private Text searchText;
    private Text responseTimeText;
    private TableViewer tableViewer;
    private TableColumnLayout tableColumnLayout;
    private int serverId;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secId = site.getSecondaryId();
        String[] ids = secId.split("&");
        this.serverId = CastUtil.cint((Object)ids[0]);
        this.objHash = CastUtil.cint((Object)ids[1]);
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Batch History List[" + TextProxy.object.getLoadText(DateUtil.yyyymmdd((long)TimeUtil.getCurrentTime(this.serverId)), this.objHash, this.serverId) + "]");
        this.initialLayout(parent);
    }

    public void search() {
        final String search = this.searchText.getText();
        final String time = this.responseTimeText.getText();
        final long[] period = this.getTimePeriod();
        final ArrayList list = new ArrayList();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(ObjectBatchHistoryView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objHash", (long)ObjectBatchHistoryView.this.objHash);
                            if (StringUtil.isNotEmpty((String)search)) {
                                param.put("filter", search);
                            }
                            if (StringUtil.isNotEmpty((String)time)) {
                                long response = Long.parseLong(time);
                                param.put("response", response);
                            }
                            param.put("from", period[0]);
                            param.put("to", period[1]);
                            tcp.process("BATCH_HISTORY_LIST", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    BatchPack pack = new BatchPack();
                                    pack.readSimple(in);
                                    list.add(pack);
                                    pack.index = list.size();
                                }
                            });
                        }
                        catch (Throwable t) {
                            ConsoleProxy.errorSafe(t.toString());
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)ObjectBatchHistoryView.this.tableViewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).ObjectBatchHistoryView.this.tableViewer.setInput((Object)list);
                    }
                });
            }
        });
    }

    private long[] getTimePeriod() {
        long[] period = new long[2];
        Calendar cal = Calendar.getInstance();
        cal.set(this.date.getYear(), this.date.getMonth(), this.date.getDay(), 0, 0, 0);
        long dayTime = cal.getTimeInMillis();
        dayTime -= dayTime % 1000L;
        period[0] = dayTime + (long)this.fromTime.getHours() * 3600000L + (long)this.fromTime.getMinutes() * 60000L + (long)this.fromTime.getSeconds() * 1000L;
        period[1] = dayTime + (long)this.toTime.getHours() * 3600000L + (long)this.toTime.getMinutes() * 60000L + (long)this.toTime.getSeconds() * 1000L;
        return period;
    }

    private void initialLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.createUpperMenu(composite);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        this.createTableViewer(tableComposite);
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67586);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent evt) {
                StructuredSelection sel = (StructuredSelection)evt.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof BatchPack) {
                    BatchPack pack = (BatchPack)o;
                    Display display = ObjectBatchHistoryView.this.getViewSite().getShell().getDisplay();
                    new OpenBatchDetailJob(display, pack, ObjectBatchHistoryView.this.serverId).schedule();
                } else {
                    System.out.println(o);
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.tableViewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createUpperMenu(Composite composite) {
        Group parentGroup = new Group(composite, 0);
        parentGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(10, false);
        parentGroup.setLayout((Layout)layout);
        Label label = new Label((Composite)parentGroup, 0x1000000);
        label.setText("End Time");
        this.date = new DateTime((Composite)parentGroup, 32);
        this.fromTime = new DateTime((Composite)parentGroup, 128);
        this.fromTime.setTime(0, 0, 0);
        label = new Label((Composite)parentGroup, 0x1000000);
        label.setText(" ~ ");
        this.toTime = new DateTime((Composite)parentGroup, 128);
        this.toTime.setTime(23, 59, 59);
        label = new Label((Composite)parentGroup, 131072);
        label.setText("Job ID");
        this.searchText = new Text((Composite)parentGroup, 18432);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.minimumWidth = 150;
        this.searchText.setLayoutData((Object)gridData);
        label = new Label((Composite)parentGroup, 131072);
        label.setText("Min Response Time");
        this.responseTimeText = new Text((Composite)parentGroup, 18432);
        gridData = new GridData(16384, 0x1000000, true, false);
        gridData.minimumWidth = 80;
        this.responseTimeText.setLayoutData((Object)gridData);
        final Button applyButton = new Button((Composite)parentGroup, 8);
        applyButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        applyButton.setImage(Images.filter);
        applyButton.setText("Search");
        applyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExUtil.exec(new Runnable(){

                    @Override
                    public void run() {
                        ObjectBatchHistoryView.this.search();
                    }
                });
            }
        });
        this.searchText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    applyButton.notifyListeners(13, new Event());
                }
            }
        });
    }

    private void createColumns() {
        BatchColumnEnum[] batchColumnEnumArray = BatchColumnEnum.values();
        int n = batchColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            BatchColumnEnum column = batchColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case NO: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return "" + ((BatchPack)element).index;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return String.valueOf(DateUtil.yyyymmdd((long)((BatchPack)element).startTime)) + " " + DateUtil.hhmmss((long)((BatchPack)element).startTime);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case JOBID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return ((BatchPack)element).batchJobId;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case RESPONSETIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return String.format("%,13d", ((BatchPack)element).elapsedTime);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SQLTIME: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return String.format("%,13d", ((BatchPack)element).sqlTotalTime / 1000000L);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SQLRUNS: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return String.format("%,13d", ((BatchPack)element).sqlTotalRuns);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case THREADS: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return String.format("%,13d", ((BatchPack)element).threadCnt);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case STACK: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof BatchPack) {
                                return ((BatchPack)element).isStack ? "O" : "";
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)ObjectBatchHistoryView.this.tableViewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    public void setFocus() {
    }

    static enum BatchColumnEnum {
        NO("No", 60, 131072, true, true, true),
        TIME("Time", 100, 0x1000000, true, true, false),
        JOBID("Job ID", 100, 16384, true, true, false),
        RESPONSETIME("Response Time", 120, 131072, true, true, true),
        SQLTIME("SQL Time", 120, 131072, true, true, true),
        SQLRUNS("SQL Runs", 120, 131072, true, true, true),
        THREADS("Threads", 100, 131072, true, true, true),
        STACK("Stack", 50, 0x1000000, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private BatchColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

