/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.actions;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Activator;
import scouter.client.Images;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageCombo;
import scouter.client.util.UIUtil;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.Value;
import scouter.util.StringUtil;

public class DefineObjectTypeAction
extends Action {
    public static final int DEFINE_MODE = 0;
    public static final int EDIT_MODE = 1;
    private final IWorkbenchWindow window;
    int serverId;
    String objType;
    int mode;

    public DefineObjectTypeAction(IWorkbenchWindow window, int serverId, String objType, int mode) {
        this.window = window;
        this.serverId = serverId;
        this.objType = objType;
        this.mode = mode;
        if (mode == 0) {
            this.setText("Define Object Type");
        } else if (mode == 1) {
            this.setText("Edit Object Type");
        }
    }

    public void run() {
        new DefineObjectTypeDialog().show(this.objType);
    }

    class DefineObjectTypeDialog {
        Text objTypeTxt;
        Text displayTxt;
        ImageCombo familyCombo;
        ImageCombo iconCombo;
        Button subObjectCheck;
        CounterEngine counterEngine;

        DefineObjectTypeDialog() {
            this.counterEngine = ServerManager.getInstance().getServer(DefineObjectTypeAction.this.serverId).getCounterEngine();
        }

        void show(String objType) {
            String[] familys;
            final Shell dialog = new Shell(DefineObjectTypeAction.this.window.getShell(), 67680);
            UIUtil.setDialogDefaultFunctions(dialog);
            if (DefineObjectTypeAction.this.mode == 0) {
                dialog.setText("Define Object Type");
            } else if (DefineObjectTypeAction.this.mode == 1) {
                dialog.setText("Edit Object Type");
            }
            dialog.setLayout((Layout)new GridLayout(1, true));
            Composite mainComp = new Composite((Composite)dialog, 0);
            mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
            mainComp.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(mainComp, 0);
            label.setText("Object Type");
            GridData gr = new GridData(16384, 0x1000000, false, false);
            gr.widthHint = 100;
            label.setLayoutData((Object)gr);
            this.objTypeTxt = new Text(mainComp, 2052);
            gr = new GridData(4, 0x1000000, true, false);
            this.objTypeTxt.setLayoutData((Object)gr);
            this.objTypeTxt.setText(objType);
            this.objTypeTxt.setEnabled(false);
            label = new Label(mainComp, 0);
            label.setText("Display Name");
            gr = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)gr);
            this.displayTxt = new Text(mainComp, 2052);
            gr = new GridData(4, 0x1000000, true, false);
            gr.widthHint = 200;
            this.displayTxt.setLayoutData((Object)gr);
            label = new Label(mainComp, 0);
            label.setText("Family");
            gr = new GridData(16384, 0x1000000, false, false);
            this.familyCombo = new ImageCombo(mainComp, 2056);
            this.familyCombo.setBackground(ColorUtil.getInstance().getColor("white"));
            gr = new GridData(4, 0x1000000, true, false);
            this.familyCombo.setLayoutData(gr);
            String[] stringArray = familys = this.counterEngine.getFamilyNames();
            int n = familys.length;
            int n2 = 0;
            while (n2 < n) {
                String family = stringArray[n2];
                this.familyCombo.add(family, null);
                ++n2;
            }
            this.familyCombo.select(0);
            label = new Label(mainComp, 0);
            label.setText("Icon");
            gr = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)gr);
            this.iconCombo = new ImageCombo(mainComp, 2056);
            this.iconCombo.setBackground(ColorUtil.getInstance().getColor("white"));
            gr = new GridData(4, 0x1000000, true, false);
            this.iconCombo.setLayoutData(gr);
            try {
                Enumeration en = Activator.getDefault().getBundle().findEntries("icons/object/", "*.png", false);
                while (en.hasMoreElements()) {
                    URL url = (URL)en.nextElement();
                    String name = new File((url = FileLocator.resolve((URL)url)).getFile()).getName();
                    if (name.contains("_inact.")) continue;
                    Image img = Activator.getImage("icons/object/" + name);
                    this.iconCombo.add(name, img);
                    this.iconCombo.setData(name, name.substring(0, name.lastIndexOf(".")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.subObjectCheck = new Button(mainComp, 32);
            this.subObjectCheck.setText("Sub-object");
            this.subObjectCheck.setLayoutData((Object)new GridData(131072, 4, true, false, 2, 1));
            CLabel warnLabel = new CLabel(mainComp, 0);
            warnLabel.setImage(Images.exclamation);
            warnLabel.setText("This setting will affect all clients");
            gr = new GridData(4, 0x1000000, true, false, 2, 1);
            warnLabel.setLayoutData((Object)gr);
            if (DefineObjectTypeAction.this.mode == 0) {
                ArrayList objTypeList = this.counterEngine.getAllObjectType();
                for (String anotherObjType : objTypeList) {
                    if (objType.equals(anotherObjType) || !objType.startsWith(anotherObjType)) continue;
                    this.subObjectCheck.setSelection(true);
                    break;
                }
            } else if (DefineObjectTypeAction.this.mode == 1) {
                this.displayTxt.setText(this.counterEngine.getDisplayNameObjectType(objType));
                this.familyCombo.setText(this.counterEngine.getObjectType(objType).getFamily().getName());
                String icon = this.counterEngine.getObjectType(objType).getIcon();
                this.iconCombo.setText(String.valueOf(icon == null ? objType : icon) + ".png");
                this.subObjectCheck.setSelection(this.counterEngine.getObjectType(objType).isSubObject());
            }
            Composite bottomComp = new Composite((Composite)dialog, 0);
            bottomComp.setLayoutData((Object)new GridData(4, 4, true, true));
            bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
            Button cancelBtn = new Button(bottomComp, 8);
            cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
            cancelBtn.setText("&Cancel");
            cancelBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    dialog.close();
                }
            });
            Button okBtn = new Button(bottomComp, 8);
            okBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, cancelBtn, -5, null, -1, 100));
            okBtn.setText("&Ok");
            okBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String display = DefineObjectTypeDialog.this.displayTxt.getText();
                    if (StringUtil.isEmpty((String)display)) {
                        MessageDialog.openWarning((Shell)dialog, (String)"Required Filed", (String)"DisplayName is required");
                        return;
                    }
                    final String type = DefineObjectTypeDialog.this.objTypeTxt.getText();
                    final String displayName = DefineObjectTypeDialog.this.displayTxt.getText();
                    final String family = DefineObjectTypeDialog.this.familyCombo.getText();
                    final String icon = (String)DefineObjectTypeDialog.this.iconCombo.getData(DefineObjectTypeDialog.this.iconCombo.getText());
                    final BooleanValue subObject = new BooleanValue(DefineObjectTypeDialog.this.subObjectCheck.getSelection());
                    ExUtil.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            TcpProxy tcp = TcpProxy.getTcpProxy(((DefineObjectTypeDialog)(this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.serverId);
                            try {
                                MapPack param = new MapPack();
                                param.put("name", type);
                                param.put("disp", displayName);
                                param.put("family", family);
                                param.put("icon", icon);
                                param.put("sub-object", (Value)subObject);
                                String requestCmd = ((DefineObjectTypeDialog)(this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.mode == 1 ? "EDIT_OBJECT_TYPE" : "DEFINE_OBJECT_TYPE";
                                final Value v = tcp.getSingleValue(requestCmd, (Pack)param);
                                ExUtil.exec((Composite)((DefineObjectTypeDialog)(this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.window.getShell(), new Runnable(){

                                    @Override
                                    public void run() {
                                        if (v != null && ((BooleanValue)v).value) {
                                            MessageDialog.openInformation((Shell)((DefineObjectTypeDialog)((this).this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.window.getShell(), (String)"Success", (String)(String.valueOf(((DefineObjectTypeDialog)((this).this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.mode == 1 ? "Edit" : "Add") + " successfully."));
                                            ExUtil.asyncRun(new Runnable(){

                                                @Override
                                                public void run() {
                                                    TcpProxy tcp = TcpProxy.getTcpProxy(((DefineObjectTypeDialog)(((this).this).this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.serverId);
                                                    try {
                                                        try {
                                                            MapPack param = new MapPack();
                                                            param.put("command", "REFETCH_COUNTER_XML");
                                                            param.put("fromSession", ServerManager.getInstance().getServer(((DefineObjectTypeDialog)(((this).this).this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.serverId).getSession());
                                                            tcp.getSingle("REMOTE_CONTROL_ALL", (Pack)param);
                                                        }
                                                        catch (Exception e) {
                                                            ConsoleProxy.errorSafe(e.toString());
                                                            TcpProxy.putTcpProxy(tcp);
                                                        }
                                                    }
                                                    finally {
                                                        TcpProxy.putTcpProxy(tcp);
                                                    }
                                                }
                                            });
                                        } else {
                                            MessageDialog.openError((Shell)((DefineObjectTypeDialog)((this).this).DefineObjectTypeDialog.this).DefineObjectTypeAction.this.window.getShell(), (String)"Failed", (String)"Add Failed. Please try again or contact administrator.");
                                        }
                                    }
                                });
                            }
                            finally {
                                TcpProxy.putTcpProxy(tcp);
                            }
                        }
                    });
                    dialog.close();
                }
            });
            dialog.pack();
            dialog.open();
        }
    }
}

