/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import scouter.client.configuration.views.AlertScriptingView;
import scouter.client.util.ImageUtil;

public class OpenAlertScriptingAction
extends Action {
    public static final String ID = OpenAlertScriptingAction.class.getName();
    private final IWorkbenchWindow window;
    private int serverId;
    private String familyName;
    private String counterName;
    private String counterDisplayName;

    public OpenAlertScriptingAction(IWorkbenchWindow window, String label, Image image, int serverId, String familyName, String counterName, String counterDisplayName) {
        this.window = window;
        this.serverId = serverId;
        this.familyName = familyName;
        this.counterName = counterName;
        this.counterDisplayName = counterDisplayName;
        this.setText(label);
        this.setId(ID);
        this.setImageDescriptor(ImageUtil.getImageDescriptor(image));
    }

    public void run() {
        if (this.window != null) {
            try {
                AlertScriptingView v = (AlertScriptingView)this.window.getActivePage().showView(AlertScriptingView.ID, String.valueOf(this.serverId) + "-c-" + this.counterName, 1);
                if (v != null) {
                    v.setInput(this.serverId, this.familyName, this.counterName, this.counterDisplayName);
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
            }
        }
    }
}

