/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import scouter.server.support.telegraf.TgmConfig;

public class TagFilterMapping {
    public String tag;
    public String mappingValue;

    public TagFilterMapping() {
    }

    public TagFilterMapping(String tag, String mappingValue) {
        this.tag = tag;
        this.mappingValue = mappingValue;
    }

    public static List<TagFilterMapping> of(List<TgmConfig.TagFilter> tfList) {
        ArrayList<TagFilterMapping> list = new ArrayList<TagFilterMapping>();
        for (TgmConfig.TagFilter filter : tfList) {
            for (String match : filter.match) {
                TagFilterMapping mapping = new TagFilterMapping(filter.tag, match);
                list.add(mapping);
            }
        }
        return list;
    }

    public static List<TgmConfig.TagFilter> toOriginal(List<TagFilterMapping> mappings) {
        return mappings.stream().collect(Collectors.groupingBy(m -> m.tag)).entrySet().stream().map(e -> new TgmConfig.TagFilter((String)e.getKey(), ((List)e.getValue()).stream().map(m -> m.mappingValue).collect(Collectors.toList()).toArray(new String[0]))).collect(Collectors.toList());
    }
}

