/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.GroupPolicyConstants;
import scouter.client.server.ServerManager;
import scouter.client.util.ColorUtil;
import scouter.client.util.ConsoleProxy;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.UIUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.util.ClassUtil;
import scouter.util.StringUtil;

public class AccountGroupPolicyView
extends ViewPart {
    public static final String ID = AccountGroupPolicyView.class.getName();
    public static final String CHECK = "\u2713";
    public static final String UNCHECK = "X";
    int serverId;
    Composite comp;
    Table policyTable;
    private TableColumnLayout tableColumnLayout = new TableColumnLayout();
    static Set<Object> totalSet = ClassUtil.getPublicFinalValueMap(GroupPolicyConstants.class, String.class).keySet();
    ArrayList<String> groupList = new ArrayList();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.serverId = Integer.valueOf(site.getSecondaryId());
    }

    public void createPartControl(final Composite parent) {
        this.setPartName("Policy[" + ServerManager.getInstance().getServer(this.serverId).getName() + "]");
        this.comp = new Composite(parent, 0);
        this.policyTable = new Table(this.comp, 66304);
        this.policyTable.setHeaderVisible(true);
        this.policyTable.setLinesVisible(true);
        this.comp.setLayout((Layout)this.tableColumnLayout);
        TableColumn column = new TableColumn(this.policyTable, 0x1000000);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(170, true));
        column.setText("");
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        if (ServerManager.getInstance().getServer(this.serverId).isAllowAction("AllowEditGroupPolicy")) {
            this.policyTable.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    Point pt = new Point(event.x, event.y);
                    TableItem item = AccountGroupPolicyView.this.policyTable.getItem(pt);
                    if (item != null) {
                        int col = 1;
                        while (col < AccountGroupPolicyView.this.policyTable.getColumnCount()) {
                            Rectangle rect = item.getBounds(col);
                            if (rect.contains(pt)) {
                                String text = item.getText(col);
                                if (StringUtil.isEmpty((String)text)) {
                                    item.setForeground(col, ColorUtil.getInstance().getColor("red"));
                                    item.setText(col, AccountGroupPolicyView.CHECK);
                                    break;
                                }
                                if (AccountGroupPolicyView.CHECK.equals(text)) {
                                    if (item.getForeground((int)col).getRGB().red == 255) {
                                        item.setText(col, "");
                                        break;
                                    }
                                    item.setForeground(col, ColorUtil.getInstance().getColor("red"));
                                    item.setText(col, AccountGroupPolicyView.UNCHECK);
                                    break;
                                }
                                if (!AccountGroupPolicyView.UNCHECK.equals(text)) break;
                                item.setForeground(col, ColorUtil.getInstance().getColor(2));
                                item.setText(col, AccountGroupPolicyView.CHECK);
                                break;
                            }
                            ++col;
                        }
                    }
                }
            });
            man.add((IAction)new Action("Add AccountGroup", ImageUtil.getImageDescriptor(Images.add)){

                public void run() {
                    new NewAccountGroupDailog().show();
                }
            });
            man.add((IAction)new Action("Save", ImageUtil.getImageDescriptor(Images.save)){

                public void run() {
                    if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)"Save Account Group Polies", (String)"These polices will be applied all clients. Continue?")) {
                        new PolicySaveJob(AccountGroupPolicyView.this.makePolicyMap()).schedule();
                    }
                }
            });
            man.add((IContributionItem)new Separator());
        }
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                AccountGroupPolicyView.this.load();
            }
        });
        this.load();
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                MapPack p;
                block5: {
                    p = null;
                    TcpProxy tcp = TcpProxy.getTcpProxy(AccountGroupPolicyView.this.serverId);
                    try {
                        try {
                            p = (MapPack)tcp.getSingle("GET_GROUP_POLICY_ALL", null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                final MapPack pack = p;
                ExUtil.exec(AccountGroupPolicyView.this.comp, new Runnable(){

                    @Override
                    public void run() {
                        (this).AccountGroupPolicyView.this.policyTable.setRedraw(false);
                        (this).AccountGroupPolicyView.this.policyTable.removeAll();
                        while ((this).AccountGroupPolicyView.this.policyTable.getColumnCount() > 1) {
                            (this).AccountGroupPolicyView.this.policyTable.getColumns()[(this).AccountGroupPolicyView.this.policyTable.getColumnCount() - 1].dispose();
                        }
                        (this).AccountGroupPolicyView.this.groupList.clear();
                        TreeSet groupSet = new TreeSet(pack.keySet());
                        for (String name : groupSet) {
                            TableColumn column = new TableColumn((this).AccountGroupPolicyView.this.policyTable, 0x1000000);
                            column.setText(name);
                            (this).AccountGroupPolicyView.this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(100, true));
                            (this).AccountGroupPolicyView.this.groupList.add(name);
                        }
                        String[] policyArray = totalSet.toArray(new String[totalSet.size()]);
                        int i = 0;
                        while (i < policyArray.length) {
                            TableItem item = new TableItem((this).AccountGroupPolicyView.this.policyTable, 0x1000000);
                            item.setText(0, policyArray[i]);
                            int j = 1;
                            for (String group : groupSet) {
                                MapValue mv = (MapValue)pack.get(group);
                                Value v = mv.get(policyArray[i]);
                                if (v != null) {
                                    BooleanValue bv = (BooleanValue)v;
                                    if (bv.value) {
                                        item.setText(j, AccountGroupPolicyView.CHECK);
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        (this).AccountGroupPolicyView.this.policyTable.setRedraw(true);
                        (this).AccountGroupPolicyView.this.comp.layout(true, true);
                    }
                });
            }
        });
    }

    public void setFocus() {
    }

    private MapPack makePolicyMap() {
        TableItem[] items;
        MapPack pack = new MapPack();
        TableItem[] tableItemArray = items = this.policyTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String policy = item.getText(0);
            if (!StringUtil.isEmpty((String)policy)) {
                int groupIndex = 1;
                for (String group : this.groupList) {
                    Value v = pack.get(group);
                    if (v == null) {
                        v = new MapValue();
                        pack.put(group, v);
                    }
                    MapValue mv = (MapValue)v;
                    String value = item.getText(groupIndex);
                    if (CHECK.equals(value)) {
                        mv.put(policy, (Value)new BooleanValue(true));
                    } else {
                        mv.put(policy, (Value)new BooleanValue(false));
                    }
                    ++groupIndex;
                }
            }
            ++n2;
        }
        return pack;
    }

    class AddAccountGroupJob
    extends Job {
        private MapPack param;

        public AddAccountGroupJob(MapPack param) {
            super("Add Account Group");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Add Account Group....... ", -1);
            TcpProxy tcp = TcpProxy.getTcpProxy(AccountGroupPolicyView.this.serverId);
            try {
                try {
                    tcp.process("ADD_ACCOUNT_GROUP", this.param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            final Value v = in.readValue();
                            ExUtil.exec(((AddAccountGroupJob)AddAccountGroupJob.this).AccountGroupPolicyView.this.comp, new Runnable(){

                                @Override
                                public void run() {
                                    if (v == null) {
                                        MessageDialog.openError((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Problem occured", (String)"Can't receive response. Please try again or contact administrator.");
                                    } else {
                                        boolean result = ((BooleanValue)v).value;
                                        if (result) {
                                            TableItem[] items;
                                            TableColumn column = new TableColumn(((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.policyTable, 0x1000000);
                                            String name = (this).AddAccountGroupJob.this.param.getText("name");
                                            MapValue mv = (MapValue)(this).AddAccountGroupJob.this.param.get("policy");
                                            column.setText(name);
                                            ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(100, true));
                                            int colIndex = ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.policyTable.getColumnCount() - 1;
                                            ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.groupList.add(name);
                                            TableItem[] tableItemArray = items = ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.policyTable.getItems();
                                            int n = items.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                TableItem item = tableItemArray[n2];
                                                String policy = item.getText(0);
                                                Value v2 = mv.get(policy);
                                                if (v2 == null) {
                                                    item.setText(colIndex, "");
                                                } else {
                                                    BooleanValue bv = (BooleanValue)v2;
                                                    if (bv.value) {
                                                        item.setText(colIndex, AccountGroupPolicyView.CHECK);
                                                    } else {
                                                        item.setText(colIndex, "");
                                                    }
                                                }
                                                ++n2;
                                            }
                                            ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.policyTable.setRedraw(true);
                                            ((AddAccountGroupJob)(this).AddAccountGroupJob.this).AccountGroupPolicyView.this.comp.layout(true, true);
                                            MessageDialog.openInformation((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Success", (String)"Add successfully.");
                                        } else {
                                            MessageDialog.openError((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Failed", (String)"Add Failed. Please try again or contact administrator.");
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Throwable th) {
                    ConsoleProxy.errorSafe(th.getMessage());
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            return Status.OK_STATUS;
        }
    }

    class NewAccountGroupDailog {
        Table table;

        NewAccountGroupDailog() {
        }

        void show() {
            String[] policyArray;
            final Shell dialog = new Shell(AccountGroupPolicyView.this.getSite().getShell().getDisplay(), 67680);
            UIUtil.setDialogDefaultFunctions(dialog);
            dialog.setLayout((Layout)new GridLayout(2, false));
            dialog.setText("Add Account Group");
            Composite nameComp = new Composite((Composite)dialog, 0);
            GridData gr = new GridData(16384, 0x1000000, true, true, 2, 1);
            nameComp.setLayoutData((Object)gr);
            nameComp.setLayout((Layout)new RowLayout());
            final Text nameTxt = new Text(nameComp, 2052);
            nameTxt.setLayoutData((Object)new RowData(150, -1));
            this.table = new Table((Composite)dialog, 2848);
            gr = new GridData(4, 4, true, true);
            gr.widthHint = 250;
            gr.heightHint = 350;
            this.table.setLayoutData((Object)gr);
            String[] stringArray = policyArray = totalSet.toArray(new String[totalSet.size()]);
            int n = policyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String policy = stringArray[n2];
                TableItem item = new TableItem(this.table, 0);
                item.setText(policy);
                ++n2;
            }
            Composite buttonComp = new Composite((Composite)dialog, 0);
            gr = new GridData(4, 4, false, true);
            buttonComp.setLayoutData((Object)gr);
            buttonComp.setLayout((Layout)UIUtil.formLayout(3, 3));
            Button selectAllBtn = new Button(buttonComp, 8);
            selectAllBtn.setLayoutData((Object)UIUtil.formData(null, -1, 0, 5, null, -1, null, -1, 100));
            selectAllBtn.setText("&Select All");
            selectAllBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = NewAccountGroupDailog.this.table.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(true);
                        ++n2;
                    }
                }
            });
            Button deselectAllBtn = new Button(buttonComp, 8);
            deselectAllBtn.setLayoutData((Object)UIUtil.formData(null, -1, selectAllBtn, 5, null, -1, null, -1, 100));
            deselectAllBtn.setText("&Deselect All");
            deselectAllBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem[] items;
                    TableItem[] tableItemArray = items = NewAccountGroupDailog.this.table.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(false);
                        ++n2;
                    }
                }
            });
            Composite bottomComp = new Composite((Composite)dialog, 0);
            bottomComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            bottomComp.setLayout((Layout)UIUtil.formLayout(3, 3));
            Button cancelBtn = new Button(bottomComp, 8);
            cancelBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, 100, -5, null, -1, 100));
            cancelBtn.setText("&Cancel");
            cancelBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    dialog.close();
                }
            });
            Button okBtn = new Button(bottomComp, 8);
            okBtn.setLayoutData((Object)UIUtil.formData(null, -1, null, -1, cancelBtn, -5, null, -1, 100));
            okBtn.setText("&Ok");
            okBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem[] items;
                    String name = nameTxt.getText();
                    if (StringUtil.isEmpty((String)name)) {
                        MessageDialog.openWarning((Shell)dialog, (String)"Required Name", (String)"Name is required.");
                        nameTxt.setFocus();
                        return;
                    }
                    if (((NewAccountGroupDailog)NewAccountGroupDailog.this).AccountGroupPolicyView.this.groupList.contains(name)) {
                        MessageDialog.openWarning((Shell)dialog, (String)"Duplicated Name", (String)"Name is duplicated.");
                        nameTxt.setFocus();
                        nameTxt.selectAll();
                        return;
                    }
                    MapPack param = new MapPack();
                    MapValue mv = new MapValue();
                    param.put("name", name);
                    param.put("policy", (Value)mv);
                    TableItem[] tableItemArray = items = NewAccountGroupDailog.this.table.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        String policy = item.getText();
                        BooleanValue bv = new BooleanValue(item.getChecked());
                        mv.put(policy, (Value)bv);
                        ++n2;
                    }
                    new AddAccountGroupJob(param).schedule();
                    dialog.close();
                }
            });
            nameTxt.setFocus();
            dialog.pack();
            dialog.open();
        }
    }

    class PolicySaveJob
    extends Job {
        private MapPack param;

        public PolicySaveJob(MapPack param) {
            super("Account Group Policy Saving");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Editing Policy....... ", -1);
            TcpProxy tcp = TcpProxy.getTcpProxy(AccountGroupPolicyView.this.serverId);
            try {
                try {
                    tcp.process("EDIT_GROUP_POLICY", this.param, new INetReader(){

                        @Override
                        public void process(DataInputX in) throws IOException {
                            final Value v = in.readValue();
                            ExUtil.exec(((PolicySaveJob)PolicySaveJob.this).AccountGroupPolicyView.this.comp, new Runnable(){

                                @Override
                                public void run() {
                                    if (v == null) {
                                        MessageDialog.openError((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Problem occured", (String)"Can't receive response. Please try again or contact administrator.");
                                    } else {
                                        boolean result = ((BooleanValue)v).value;
                                        if (result) {
                                            TableItem[] items = ((PolicySaveJob)(this).PolicySaveJob.this).AccountGroupPolicyView.this.policyTable.getItems();
                                            int colCount = ((PolicySaveJob)(this).PolicySaveJob.this).AccountGroupPolicyView.this.policyTable.getColumnCount();
                                            TableItem[] tableItemArray = items;
                                            int n = items.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                TableItem item = tableItemArray[n2];
                                                int i = 1;
                                                while (i < colCount) {
                                                    if (AccountGroupPolicyView.CHECK.equals(item.getText(i))) {
                                                        item.setForeground(i, ColorUtil.getInstance().getColor(2));
                                                        item.setText(i, AccountGroupPolicyView.CHECK);
                                                    } else {
                                                        item.setText(i, "");
                                                    }
                                                    ++i;
                                                }
                                                ++n2;
                                            }
                                            MessageDialog.openInformation((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Success", (String)"Save successfully. You should restart client to apply new polices.");
                                        } else {
                                            MessageDialog.openError((Shell)AccountGroupPolicyView.this.getSite().getShell(), (String)"Failed", (String)"Save Failed. Please try again or contact administrator.");
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (Throwable th) {
                    ConsoleProxy.errorSafe(th.getMessage());
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            return Status.OK_STATUS;
        }
    }
}

