/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.configuration.actions.EditAccountAction;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.io.DataInputX;
import scouter.lang.Account;
import scouter.lang.value.BlobValue;
import scouter.lang.value.Value;

public class AccountListView
extends ViewPart {
    public static final String ID = AccountListView.class.getName();
    private int serverId;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.serverId = Integer.valueOf(site.getSecondaryId());
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Account List[" + ServerManager.getInstance().getServer(this.serverId).getName() + "]");
        this.tableColumnLayout = new TableColumnLayout();
        parent.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(parent, 67584);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        this.createTableContextMenu();
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        man.add((IAction)new Action("Reload", ImageUtil.getImageDescriptor(Images.refresh)){

            public void run() {
                AccountListView.this.load();
            }
        });
        this.load();
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        Server server = ServerManager.getInstance().getServer(this.serverId);
        if (server.isAllowAction("AllowEditAccount")) {
            manager.add((IAction)new Action("Edit Account"){

                public void run() {
                    Object o;
                    ISelection selection = AccountListView.this.viewer.getSelection();
                    if (selection instanceof StructuredSelection && (o = ((StructuredSelection)selection).getFirstElement()) instanceof Account) {
                        new EditAccountAction(AccountListView.this.getSite().getWorkbenchWindow(), AccountListView.this.serverId, (Account)o).run();
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ArrayList list;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(AccountListView.this.serverId);
                    list = new ArrayList();
                    try {
                        try {
                            tcp.process("LIST_ACCOUNT", null, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    Value v = in.readValue();
                                    if (v.getValueType() == 60) {
                                        BlobValue bv = (BlobValue)v;
                                        Account ac = new Account();
                                        ac.toObject(bv.value);
                                        list.add(ac);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)AccountListView.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        (this).AccountListView.this.viewer.setInput((Object)list);
                    }
                });
            }
        });
    }

    private void createColumns() {
        AccountEnum[] accountEnumArray = AccountEnum.values();
        int n = accountEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccountEnum column = accountEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case ID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof Account) {
                                return ((Account)element).id;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case GROUP: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof Account) {
                                return ((Account)element).group;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case EMAIL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof Account) {
                                return ((Account)element).email;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(width, 10, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)AccountListView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    static enum AccountEnum {
        ID("ID", 50, 0x1000000, true, true, false),
        GROUP("Group", 50, 0x1000000, true, true, false),
        EMAIL("Email", 50, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private AccountEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

