/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.configuration.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.configuration.views.ApiDescEnum;
import scouter.client.net.TcpProxy;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.ColorUtil;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ExUtil;
import scouter.client.util.ImageUtil;
import scouter.client.util.JavaLineStyler;
import scouter.client.util.UndoRedoImpl;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.HashUtil;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class AlertScriptingView
extends ViewPart {
    private static final Font TERMINAL_FONT = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
    private DefaultToolTip toolTip;
    public static final String ID = AlertScriptingView.class.getName();
    private static final String DEFAULT_RULE_CONTENTS = "// void process(RealCounter $counter, PluginHelper $$) {\n// create your java code below..\n\n\n// }";
    private static final String DEFAULT_CONFIG_CONTENTS = "#history_size=150\n#silent_time=300\n#check_term=20";
    private StyledText ruleText;
    private StyledText configText;
    private Text consoleText;
    private UndoRedoImpl ruleTextUndo;
    private UndoRedoImpl configTextUndo;
    private int serverId;
    private String familyName;
    private String counterName;
    private String counterDisplayName;
    SashForm mainSashForm;
    SashForm topSashForm;
    SashForm bottomSashForm;
    int ruleContentsHash = 0;
    int configContentsHash = 0;
    private long consoleLoop = 0L;
    private int consoleIndex = 0;
    private TableColumnLayout tableColumnLayout;
    private TableViewer viewer;
    private Table table;
    private Clipboard clipboard = new Clipboard(null);
    private ArrayList<ColoringWord> configKeyword;

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.initializeColoring();
        parent.setLayout((Layout)new FillLayout());
        this.mainSashForm = new SashForm(parent, 512);
        this.mainSashForm.SASH_WIDTH = 1;
        this.topSashForm = new SashForm((Composite)this.mainSashForm, 256);
        this.topSashForm.SASH_WIDTH = 1;
        this.createRuleContentsForm((Composite)this.topSashForm);
        this.createApiDescForm((Composite)this.topSashForm);
        this.bottomSashForm = new SashForm((Composite)this.mainSashForm, 256);
        this.bottomSashForm.SASH_WIDTH = 1;
        this.createConfigContentsForm((Composite)this.bottomSashForm);
        this.createConsoleForm((Composite)this.bottomSashForm);
        this.bottomSashForm.setWeights(new int[]{2, 1});
        this.bottomSashForm.setMaximizedControl(null);
        this.bottomSashForm.setWeights(new int[]{1, 3});
        this.bottomSashForm.setMaximizedControl(null);
        this.mainSashForm.setWeights(new int[]{2, 1});
        this.mainSashForm.setMaximizedControl(null);
        this.initialToolBar();
    }

    public void setInput(int serverId, String familyName, String counterName, String counterDisplayName) {
        this.serverId = serverId;
        this.familyName = familyName;
        this.counterName = counterName;
        this.counterDisplayName = StringUtil.isEmpty((String)counterDisplayName) ? counterName : counterDisplayName;
        this.setPartName("Alert Scripting [" + this.familyName + " : " + this.counterDisplayName + "]");
        this.loadAlertScriptingContents();
        this.loadAlertScriptingConfigContents();
        this.consoleText.setText("console outputs below...\n");
        this.loadApiDesc();
    }

    public void initializeColoring() {
        this.configKeyword = new ArrayList();
        this.configKeyword.add(new ColoringWord("history_size", 9, true));
        this.configKeyword.add(new ColoringWord("silent_time", 9, true));
        this.configKeyword.add(new ColoringWord("check_term", 9, true));
    }

    private void saveContents() {
        this.readConsoleMessage(this.consoleLoop, this.consoleIndex, true);
        SaveResult configResult = this.saveConfigContents();
        if (configResult == SaveResult.SUCCESS || configResult == SaveResult.NA) {
            SaveResult ruleResult = this.saveRuleContents();
            if (ruleResult == SaveResult.FAIL) {
                AlertScriptingView.openSaveFailDialog();
            } else if (ruleResult == SaveResult.SUCCESS || configResult == SaveResult.SUCCESS) {
                this.readConsoleMessageAsync4times(this.consoleLoop, this.consoleIndex);
                AlertScriptingView.openSaveSuccessDialog();
            }
        } else {
            this.readConsoleMessageAsync4times(this.consoleLoop, this.consoleIndex);
            AlertScriptingView.openSaveFailDialog();
        }
    }

    private static void openSaveSuccessDialog() {
        MessageDialog.open((int)2, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Success", (String)"Successfully saved.", (int)0);
    }

    private static void openSaveFailDialog() {
        MessageDialog.open((int)1, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fail", (String)"Save failed!\n(Server problem or alert editing unsupported version)\nAlert script editor in client UI supported\n@Since : v1.8.0", (int)0);
    }

    private SaveResult saveConfigContents() {
        String contents = this.ruleText.getText();
        if (HashUtil.hash((String)contents) == this.ruleContentsHash) {
            return SaveResult.NA;
        }
        MapPack paramPack = new MapPack();
        paramPack.put("counterName", this.counterName);
        paramPack.put("contents", contents);
        MapPack resultPack = this.getResultMapPack("SAVE_ALERT_SCRIPTING_CONTETNS", paramPack);
        if (resultPack == null) {
            return SaveResult.FAIL;
        }
        if (resultPack.getBoolean("success")) {
            this.ruleContentsHash = HashUtil.hash((String)contents);
            return SaveResult.SUCCESS;
        }
        return SaveResult.FAIL;
    }

    private SaveResult saveRuleContents() {
        String contents = this.configText.getText();
        if (HashUtil.hash((String)contents) == this.configContentsHash) {
            return SaveResult.NA;
        }
        MapPack paramPack = new MapPack();
        paramPack.put("counterName", this.counterName);
        paramPack.put("contents", contents);
        MapPack resultPack = this.getResultMapPack("SAVE_ALERT_SCRIPTING_CONFIG_CONTETNS", paramPack);
        if (resultPack == null) {
            return SaveResult.FAIL;
        }
        if (resultPack.getBoolean("success")) {
            this.ruleContentsHash = HashUtil.hash((String)contents);
            return SaveResult.SUCCESS;
        }
        return SaveResult.FAIL;
    }

    private void createRuleContentsForm(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        Label ruleTextLabel = new Label(comp, 2048);
        ruleTextLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        ruleTextLabel.setFont(new Font(null, "Arial", 11, 1));
        ruleTextLabel.setBackground(Display.getCurrent().getSystemColor(29));
        ruleTextLabel.setText(" [ Alert Script ] ");
        this.ruleText = new StyledText(comp, 2818);
        this.ruleText.setTabs(4);
        this.ruleText.setFont(TERMINAL_FONT);
        this.ruleText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ruleText.addLineStyleListener((LineStyleListener)new JavaLineStyler());
        this.ruleText.addKeyListener((KeyListener)new SaveKeyListener());
        this.ruleTextUndo = new UndoRedoImpl(this.ruleText);
        this.ruleText.addListener(2, e -> {
            if (e.keyCode == 13) {
                String textAtPrevLine = this.ruleText.getLine(this.ruleText.getLineAtOffset(this.ruleText.getCaretOffset() - 1));
                String textAtCurrentLine = this.ruleText.getLine(this.ruleText.getLineAtOffset(this.ruleText.getCaretOffset()));
                if (textAtCurrentLine != null && textAtCurrentLine.equals(textAtPrevLine)) {
                    return;
                }
                String spaces = AlertScriptingView.getLeadingSpaces(textAtPrevLine);
                if (AlertScriptingView.getLastChar(textAtPrevLine) == '{' && (textAtCurrentLine.length() <= 0 || textAtCurrentLine.charAt(0) != '}')) {
                    spaces = String.valueOf(spaces) + "\t";
                }
                int spaceLength = spaces.length();
                this.ruleText.insert(spaces);
                this.ruleText.setCaretOffset(this.ruleText.getCaretOffset() + spaceLength);
            }
        });
    }

    private void createApiDescForm(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        Label apiDesc = new Label(comp, 2048);
        apiDesc.setLayoutData((Object)new GridData(4, 4, true, false));
        apiDesc.setFont(new Font(null, "Arial", 11, 1));
        apiDesc.setBackground(Display.getCurrent().getSystemColor(29));
        apiDesc.setText(" [ Api Help ] ");
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(tableComp, 68418);
        this.createColumns();
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        this.toolTip = new DefaultToolTip((Control)this.table, 1, true);
        this.toolTip.setFont(new Font(null, "Arial", 11, 1));
        this.toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.addApiDescTableListener();
    }

    private void addApiDescTableListener() {
        this.addApiDescTableMouseListener();
        this.addApiDescTableFocusListener();
        this.addApiDescTableKeyListener();
    }

    private void addApiDescTableKeyListener() {
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.stateMask != 262144 && e.stateMask != 0x400000 || e.keyCode != 99 && e.keyCode != 67)) {
                    StructuredSelection selection = (StructuredSelection)AlertScriptingView.this.viewer.getSelection();
                    if (selection == null) {
                        return;
                    }
                    ApiDesc apiObject = (ApiDesc)selection.getFirstElement();
                    if (apiObject != null) {
                        AlertScriptingView.this.clipboard.setContents(new Object[]{apiObject.fullSignature}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
            }
        });
    }

    private void addApiDescTableFocusListener() {
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AlertScriptingView.this.toolTip.hide();
            }
        });
    }

    private void addApiDescTableMouseListener() {
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AlertScriptingView.this.toolTip.hide();
                StructuredSelection sel = (StructuredSelection)AlertScriptingView.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ApiDesc) {
                    ApiDesc apiDesc = (ApiDesc)o;
                    String popupText = apiDesc.returnTypeName + ' ' + apiDesc.fullSignature + '\n' + " - " + apiDesc.desc;
                    AlertScriptingView.this.toolTip.setText(popupText);
                    AlertScriptingView.this.toolTip.show(new Point(e.x + 10, e.y + 20));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                StructuredSelection selection = (StructuredSelection)AlertScriptingView.this.viewer.getSelection();
                if (selection == null) {
                    return;
                }
                ApiDesc apiObject = (ApiDesc)selection.getFirstElement();
                if (apiObject != null) {
                    AlertScriptingView.this.ruleText.insert(apiObject.fullSignature);
                }
            }
        });
    }

    private void createColumns() {
        ApiDescEnum[] apiDescEnumArray = ApiDescEnum.values();
        int n = apiDescEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApiDescEnum apiDescEnum = apiDescEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(apiDescEnum.getTitle(), apiDescEnum.getWidth(), apiDescEnum.getAlignment(), apiDescEnum.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (apiDescEnum) {
                case API: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ApiDesc) {
                                return ((ApiDesc)element).fullSignature;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case RETURN: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ApiDesc) {
                                return ((ApiDesc)element).returnTypeName;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case DESC: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ApiDesc) {
                                return ((ApiDesc)element).desc;
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, true));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)AlertScriptingView.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    private void createConfigContentsForm(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        Label configTextLabel = new Label(comp, 2048);
        configTextLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        configTextLabel.setFont(new Font(null, "Arial", 11, 1));
        configTextLabel.setBackground(Display.getCurrent().getSystemColor(29));
        configTextLabel.setText(" [ Alert Configuration ] ");
        this.configText = new StyledText(comp, 2818);
        this.configText.setTabs(4);
        this.configText.setFont(TERMINAL_FONT);
        this.configText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configText.addLineStyleListener((LineStyleListener)new CustomLineStyleListener(true, this.configKeyword, true));
        this.configText.addKeyListener((KeyListener)new SaveKeyListener());
        this.configTextUndo = new UndoRedoImpl(this.configText);
    }

    private void createConsoleForm(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        Label consoleTextLabel = new Label(comp, 2048);
        consoleTextLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        consoleTextLabel.setFont(new Font(null, "Arial", 11, 1));
        consoleTextLabel.setBackground(Display.getCurrent().getSystemColor(29));
        consoleTextLabel.setText(" [ Console Output ] ");
        this.consoleText = new Text(comp, 2818);
        this.consoleText.setTabs(4);
        this.consoleText.setFont(TERMINAL_FONT);
        this.consoleText.setEditable(false);
        this.consoleText.setForeground(ColorUtil.getInstance().getColor("blue gray"));
        this.consoleText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.consoleText.addKeyListener((KeyListener)new SaveKeyListener());
    }

    private void initialToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new Action("Save", ImageUtil.getImageDescriptor(Images.save)){

            public void run() {
                AlertScriptingView.this.saveContents();
            }
        });
        toolBarManager.add((IAction)new Action("help", ImageUtil.getImageDescriptor(Images.help)){

            public void run() {
                Program.launch((String)"https://github.com/scouter-project/scouter/blob/master/scouter.document/main/Alert-Plugin-Guide.md");
            }
        });
    }

    private MapPack getResultMapPack(String requestCmd, MapPack param) {
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            MapPack mapPack = (MapPack)tcp.getSingle(requestCmd, (Pack)param);
            return mapPack;
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
    }

    private void loadAlertScriptingContents() {
        MapPack param = new MapPack();
        param.put("counterName", this.counterName);
        ExUtil.asyncRun(() -> {
            MapPack resultMapPack = this.getResultMapPack("GET_ALERT_SCRIPTING_CONTETNS", param);
            if (resultMapPack != null) {
                String contents = StringUtil.emptyToDefault((String)resultMapPack.getText("contents"), (String)DEFAULT_RULE_CONTENTS);
                this.ruleText.getDisplay().asyncExec(() -> {
                    this.ruleText.setText(contents);
                    this.ruleContentsHash = HashUtil.hash((String)contents);
                    this.ruleTextUndo.clear();
                });
            }
        });
    }

    private void loadAlertScriptingConfigContents() {
        MapPack param = new MapPack();
        param.put("counterName", this.counterName);
        ExUtil.asyncRun(() -> {
            MapPack resultMapPack = this.getResultMapPack("GET_ALERT_SCRIPTING_CONFIG_CONTETNS", param);
            if (resultMapPack != null) {
                String contents = StringUtil.emptyToDefault((String)resultMapPack.getText("contents"), (String)DEFAULT_CONFIG_CONTENTS);
                this.configText.getDisplay().asyncExec(() -> {
                    this.configText.setText(contents);
                    this.configContentsHash = HashUtil.hash((String)contents);
                    this.configTextUndo.clear();
                });
            }
        });
    }

    private void loadApiDesc() {
        ExUtil.asyncRun(() -> {
            TreeMap<String, ApiDesc> realCounterDescMap = this.loadApiDesc("GET_ALERT_REAL_COUNTER_DESC", "$counter");
            TreeMap<String, ApiDesc> pluginHelperDescMap = this.loadApiDesc("GET_PLUGIN_HELPER_DESC", "$$");
            ArrayList<ApiDesc> list = new ArrayList<ApiDesc>(realCounterDescMap.values());
            list.addAll(pluginHelperDescMap.values());
            this.table.getDisplay().asyncExec(() -> this.viewer.setInput((Object)list));
        });
    }

    private TreeMap<String, ApiDesc> loadApiDesc(String cmd, String label) {
        TreeMap<String, ApiDesc> apiDescMap = new TreeMap<String, ApiDesc>();
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            tcp.process(cmd, new MapPack(), in -> {
                MapPack mapPack = (MapPack)in.readPack();
                String desc = mapPack.getText("desc");
                String methodName = mapPack.getText("methodName");
                String returnTypeName = mapPack.getText("returnTypeName");
                ApiDesc apiDesc = new ApiDesc();
                apiDesc.desc = desc;
                apiDesc.methodName = methodName;
                apiDesc.returnTypeName = returnTypeName;
                ListValue parameterTypeNames = mapPack.getList("parameterTypeNames");
                String paramSig = Arrays.stream(parameterTypeNames.toStringArray()).collect(Collectors.joining(", "));
                apiDesc.fullSignature = label + "." + methodName + "(" + paramSig + ")";
                apiDescMap.put(apiDesc.fullSignature, apiDesc);
            });
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return apiDescMap;
    }

    private void readConsoleMessageAsync4times(long loop, long index) {
        ExUtil.asyncRun(() -> {
            ThreadUtil.sleep((long)1000L);
            this.readConsoleMessage(this.consoleLoop, this.consoleIndex, false);
            ThreadUtil.sleep((long)2000L);
            this.readConsoleMessage(this.consoleLoop, this.consoleIndex, false);
            ThreadUtil.sleep((long)2000L);
            this.readConsoleMessage(this.consoleLoop, this.consoleIndex, false);
            ThreadUtil.sleep((long)2000L);
            this.readConsoleMessage(this.consoleLoop, this.consoleIndex, false);
        });
    }

    private void readConsoleMessage(long loop, long index, boolean first) {
        MapPack param = new MapPack();
        param.put("loop", loop);
        param.put("index", index);
        ExUtil.asyncRun(() -> {
            MapPack resultMapPack = this.getResultMapPack("GET_ALERT_SCRIPT_LOAD_MESSAGE", param);
            if (resultMapPack != null) {
                this.consoleLoop = resultMapPack.getLong("loop");
                this.consoleIndex = resultMapPack.getInt("index");
                if (first) {
                    return;
                }
                ListValue messageLv = resultMapPack.getList("messages");
                String[] stringArray = messageLv.toStringArray();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String message = stringArray[n2];
                    this.consoleText.getDisplay().asyncExec(() -> this.consoleText.append(String.valueOf(message) + "\n"));
                    ++n2;
                }
            }
        });
    }

    private static char getLastChar(String line) {
        char c = '\u0000';
        char[] chars = line.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            if (chars[i] != ' ' && chars[i] != '\t') {
                c = chars[i];
                break;
            }
            ++i;
        }
        return c;
    }

    private static String getLeadingSpaces(String line) {
        char[] chars;
        char[] resultChar = new char[line.length()];
        int pos = 0;
        char[] cArray = chars = line.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '\t' && c != ' ') break;
            resultChar[pos++] = c;
            ++n2;
        }
        return new String(resultChar, 0, pos);
    }

    private static class ApiDesc {
        String desc;
        String methodName;
        String returnTypeName;
        String fullSignature;

        private ApiDesc() {
        }
    }

    private class SaveKeyListener
    extends KeyAdapter {
        private SaveKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!(keyEvent.stateMask != 262144 && keyEvent.stateMask != 0x400000 || keyEvent.keyCode != 115 && keyEvent.keyCode != 83)) {
                AlertScriptingView.this.saveContents();
            }
        }
    }

    private static enum SaveResult {
        NA,
        SUCCESS,
        FAIL;

    }
}

